/**
 * (c) 2003-2014 MuleSoft, Inc. The software in this package is published under the terms of the CPAL v1.0 license,
 * a copy of which has been included with this distribution in the LICENSE.md file.
 */


package org.mule.modules.sunsetrise;

import org.mule.api.annotations.ConnectionStrategy;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Default;
import org.mule.modules.sunsetrise.api.LatLonDate;
import org.mule.modules.sunsetrise.strategy.ConnectorConnectionStrategy;


/**
 * Anypoint Connector
 * 
 * No description available
 * 
 * @author MuleSoft, Inc.
 * 
 */
@Connector(name = "sunsetrise", friendlyName = "Sunsetrise", schemaVersion = "1.0")
public class SunsetriseConnector {

    /**
     * Connection Strategy
     */
    @ConnectionStrategy
    ConnectorConnectionStrategy connectionStrategy;
    
    /**
     * Get Sunset and Sunrise time for any location in the world<br>
     * <b>Longitude:</b>Positive in Western Hemisphere,Negative in Eastern Hemisphere<br>
     * <b>Latitude:</b>Positive in Northern Hemisphere,Negative in Southern Hemisphere
     * 
     * {@sample.xml ../../../doc/sunsetrise-connector.xml.sample sunsetrise:get-sun-set-rise-time}
     * 
     * @param in Location to use in the request
     * @return the Location with the sunset and sunrise time.
     */
    @Processor(friendlyName = "Sunrise and Sunset Times")
    public LatLonDate getSunSetRiseTime(
        @Default("#[payload]")
        LatLonDate in) {
        return connectionStrategy.getClient().getSunSetRiseTime(in);
    }

    public ConnectorConnectionStrategy getConnectionStrategy() {
        return connectionStrategy;
    }

    public void setConnectionStrategy(ConnectorConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }
   
}
