﻿using Org.Mule.Api;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Messaging;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Xml;

namespace Test.SampleComponent
{
    public class Sample
    {
        private int count = 0;

        public object ExecuteClassWithDictionary(ClassWithDictionary data)
        {
            return string.Concat(data.Guid, data.Runparams.Keys.First(), data.Runparams.Values.First());
        }

        public object ParamsDictionary(string guid, Dictionary<string, string> runparams)
        {
            return guid;
        }

        public int GetCount()
        {
            count++;

            return count;
        }

        public string Overload()
        {
            return string.Empty;
        }

        public string Overload(string a)
        {
            return a;
        }

        public string Overload(int a)
        {
            return a.ToString();
        }

        public string Overload(string a, string b)
        {
            return string.Concat(a, b);
        }

        public string Overload(string a, int b)
        {
            return string.Concat(a, b);
        }

        public string ReadFromAppSettings()
        {
            //return "from config: " + ConfigurationManager.AppSettings["test"];
            return "from config: " + ConfigurationManager.ConnectionStrings["test"].ConnectionString;
        }

        public void UseMuleMessage()
        {
            MuleContext.Current.Logger.Write("Invoking UseMuleMessage");
            //MuleContext.Current.Logger.Write("Updateing properties UseMuleMessage");
            //var originalPayload = MuleContext.Current.Message.Payload.ToString();
            //MuleContext.Current.Message.Payload = string.Concat("Updated .net", originalPayload);

            MuleContext.Current.Logger.Write("Updating properties UseMuleMessage");

            MuleContext.Current.Message.OutboundProperties.Add("foo", "bar");
            MuleContext.Current.Message.OutboundProperties.Add("another outbound", "yoohooo");
            MuleContext.Current.Message.InvocationProperties.Add("int", 1);
            MuleContext.Current.Message.InvocationProperties.Add("bool", false);
            MuleContext.Current.Message.InvocationProperties.Add("short", (short)2);
            MuleContext.Current.Message.InvocationProperties.Add("long", (long)3);
            MuleContext.Current.Message.InvocationProperties.Add("byte", (byte)4);
            MuleContext.Current.Message.SessionProperties.Add("int", 21);
            MuleContext.Current.Message.SessionProperties.Add("bool", true);
            MuleContext.Current.Message.SessionProperties.Add("short", (short)22);
            MuleContext.Current.Message.SessionProperties.Add("long", (long)22);
            MuleContext.Current.Message.SessionProperties.Add("byte", (byte)21);

            MuleContext.Current.Message.SessionProperties.Add("intArray", new[] { 1, 2, 3 });
            MuleContext.Current.Message.SessionProperties.Add("boolArray", new[] { true, false });
            MuleContext.Current.Message.SessionProperties.Add("charArray", new[] { 'c', 'j' });
            MuleContext.Current.Message.SessionProperties.Add("shortArray", new[] { (short)0, (short)4 });
            MuleContext.Current.Message.SessionProperties.Add("floatArray", new[] { (float)0, (float)4 });
            MuleContext.Current.Message.SessionProperties.Add("doubleArray", new[] { 1.1D, 2.2D });

            var binary = (byte[])MuleContext.Current.Message.InvocationProperties["binary"];
            var text = System.Text.Encoding.UTF8.GetString(binary);

            var updatedText = string.Concat(text, " from .Net");

            MuleContext.Current.Message.InvocationProperties["binary"] = System.Text.Encoding.UTF8.GetBytes(updatedText);
            MuleContext.Current.Message.InvocationProperties["text"] = updatedText;

            if ((bool)MuleContext.Current.Message.InvocationProperties["increment"])
            {
                MuleContext.Current.Logger.Write("Incremeting sessionInt session property");
                MuleContext.Current.Message.SessionProperties["sessionInt"] = (int)MuleContext.Current.Message.SessionProperties["sessionInt"] + 1;
            }

            MuleContext.Current.Logger.Write("Adding new Invocation property");
            MuleContext.Current.Message.InvocationProperties["newProp"] = "I was added in .Net";
        }

        public object ReadMuleMessageProperties()
        {
            MuleContext.Current.Logger.Write("Invoking read mule message props");
            StringBuilder sb = new StringBuilder();

            sb.AppendLine("Invocation: ");
            foreach (var item in MuleContext.Current.Message.InvocationProperties)
            {
                if (item.Value is byte[])
                {
                    var binary = (byte[])MuleContext.Current.Message.InvocationProperties["binary"];
                    var text = System.Text.Encoding.UTF8.GetString(binary);
                    sb.AppendFormat(" {0} : {1} | ", item.Key, text);
                }
                else
                {
                    sb.AppendFormat(" {0} : {1} | ", item.Key, item.Value);
                }
                
            }

            sb.AppendLine("Outbound: ");
            foreach (var item in MuleContext.Current.Message.OutboundProperties)
            {
                sb.AppendFormat(" {0} : {1} | ", item.Key, item.Value);
            }

            sb.AppendLine("Session: ");
            foreach (var item in MuleContext.Current.Message.SessionProperties)
            {
                if (item.Value.GetType().IsArray)
                {
                    var data = (System.Array)item.Value;
                    var type = data.GetType().GetElementType();
                    foreach (var item2 in data.Cast<object>())
                    {
                        sb.AppendFormat(" {0} : {1} | ", type.ToString(), item2.ToString());
                    }
                }
                else
                {
                    sb.AppendFormat(" {0} : {1} | ", item.Key, item.Value);
                }
            }

            return sb.ToString();
        }


        public object ModifyXmlMessage(XmlDocument xml)
        {
            var node = xml.SelectSingleNode("MyMessage").SelectSingleNode("Counter");
            node.InnerText = (int.Parse(node.InnerText) + 1).ToString();
            return xml;
        }
        public object UpdateMessage(Message message)
        {
            message.Label = string.Concat("updated: ", message.Label);
            message.Priority = MessagePriority.Highest;

            var content = System.Text.Encoding.UTF8.GetString((byte[])message.Body);

            message.Body = string.Concat("updated from .net: ", content);
            message.BodyType = 1;

            return message.ToMsmqMessage();
        }
        public object GetMessage([MuleMessage(From = MessagePart.FromQuery)]string data)
        {
            //var msg = new MsmqMessage();
            //msg.Label = "foo";
            //msg.MachineName = Environment.MachineName;
            //msg.Id = "myId";

            //msg.Body = System.Text.Encoding.UTF8.GetBytes(data);

            //return msg;
            var message = new Message();
            message.Label = "foo";
            message.AcknowledgeType = AcknowledgeTypes.PositiveArrival;
            message.AttachSenderId = true;
            message.BodyType = 1;
            message.ConnectorType = Guid.NewGuid();
            message.CorrelationId = "correlation";
            message.Extension = System.Text.Encoding.UTF8.GetBytes("extension");
            //message.LookupId = 0;
            //message.MessageType = MessageType.Acknowledgment;
            message.Priority = MessagePriority.High;
            message.UseTracing = true;

            return message.ToMsmqMessage();
        }

        public object ExecuteString()
        {
            return null;
        }

        public object ExecuteStringArray2D(string[][] data)
        {
            return data.Select(x => string.Join(" - ", x));
        }

        public object ExecuteByteArray2D(byte[][] data)
        {
            StringBuilder sb = new StringBuilder();
            foreach (var item in data)
            {
                  var readableData = System.Text.Encoding.UTF8.GetString(item);
                  sb.Append(readableData);
            }

            return sb.ToString();
        }

        public byte[] GetBytes(byte[] data)
        {
            var readableData = System.Text.Encoding.UTF8.GetString(data);

            return System.Text.Encoding.UTF8.GetBytes(readableData);
        }

        public object GetCollection([MuleMessage(From = MessagePart.FromQuery)] int count)
        {
            var result = new List<Person>();

            for (int i = 0; i < count; i++)
            {
                result.Add(new Person() { Id = i, Name = string.Concat("Name ", i), LastName = string.Concat("LastName ", i) });
            }

            return result;
        }

        public object GetFromSession([MuleMessage(From = MessagePart.FromSessionProperty)] bool sessionValue)
        {
            return sessionValue.ToString();
        }

        public object ExecuteComplexMix(Person person, 
            [MuleMessage(From=MessagePart.FromInboundProperty)]int id,
            [MuleMessage(From=MessagePart.FromSessionProperty)]bool? increment)
        {
            person.Name += " updated from .net";

            if (increment.HasValue && increment.Value)
            {
                person.Id = id + 1;
            }
            else
            {
                person.Id = id;
            }

            person.MyRide.Brand = person.MyRide.Brand.Replace("GM", "Chevrolet");
            person.MyRide.Model = person.MyRide.Model + " - " + "400x";

            person.MyRide.ExteriorColor.Name += "ISH";
            person.MyRide.ExteriorColor.RGB = "no clue";
            return person;
        }

        public MuleMessage SetPayload()
        {
            var message = new MuleMessage();
            message.Payload = "foo!";

            return message;
        }

        public object ExecuteComplex(Person person)
        {
            person.Name += " updated from .net";
            person.MyRide.Brand = person.MyRide.Brand.Replace("GM", "Chevrolet");
            person.MyRide.Model = person.MyRide.Model + " - " + "400x";

            person.MyRide.ExteriorColor.Name += "ISH";
            person.MyRide.ExteriorColor.RGB = "no clue";

            MuleContext.Current.Message.SessionProperties["dotnet"] = System.Text.Encoding.UTF8.GetBytes("Cheers from .Net! in a session property.");

            return person;
        }

        public object ExecuteDateTime(DateTime date)
        {
            return new { Date = date };
        }

        public object ExecuteSimple([MuleMessage(From = MessagePart.FromBody)] string name, 
            [MuleMessage(From = MessagePart.FromBody)] int age)
        {
            return new { Name = name, Age = age };
        }

        public object GetDataFromVariable([MuleMessage(From = MessagePart.FromInvocationProperty)] int myVar)
        {
            return new { myVar = myVar };
        }

        public object GetObjectFromVariable([MuleMessage(From = MessagePart.FromInvocationProperty)] Person myObject)
        {
            myObject.Name += " extracted from Variable";

            return myObject;
        }

        public object ReturnString()
        {
            return "foo";
        }

        public object ReturnInteger()
        {
            return 1;
        }
        public object ExecuteXml(XmlDocument xml)
        {
            var node = xml.SelectSingleNode("Person").SelectSingleNode("id");
            node.InnerText = "99";
            return xml;
        }

        public object SaveFile([MuleMessage(From = MessagePart.FromQuery)] string path, [MuleMessage(From = MessagePart.FromQuery)] string content)
        {
            var file = System.IO.File.CreateText(path);
            file.Write(content);
            file.Flush();
            file.Close();

            return "OK";
        }

        public Task<int> ExecuteTaskWithResult()
        {
            return Task.Factory.StartNew<int>(
                () =>
                {
                    Thread.Sleep(10000);
                    return 1;
                });
        }

        public Task ExecuteTask()
        {
            return Task.Factory.StartNew(
                () =>
                {
                    Thread.Sleep(5000);
                });
        }

        public DataSet GetDataSet()
        {
            var ds = new DataSet();

            var table = new DataTable("Person");

            table.Columns.Add("Name", typeof(string));
            table.Columns.Add("LastName", typeof(string));
            table.Columns.Add("Age", typeof(int));

            for (int i = 0; i < 10; i++)
            {
                table.Rows.Add("Name " + i.ToString(), "LastName " + i.ToString(), i);
            }

            ds.Tables.Add(table);

            return ds;
        }

        public DataTable GetDataTable()
        {
            var table = new DataTable("Person");

            table.Columns.Add("Name", typeof(string));
            table.Columns.Add("LastName", typeof(string));
            table.Columns.Add("Age", typeof(int));

            for (int i = 0; i < 10; i++)
            {
                table.Rows.Add("Name " + i.ToString(), "LastName " + i.ToString(), i);
            }
            
            return table;
        }

        public DataRow GetDataRow()
        {
            var table = new DataTable("Person");

            table.Columns.Add("Name", typeof(string));
            table.Columns.Add("LastName", typeof(string));
            table.Columns.Add("Age", typeof(int));

            table.Rows.Add("Name 0", "LastName 0", 0);
            
            return table.Rows[0];
        }

        public object GetTypeMetadata(string type)
        {
            return MetadataHelper.GetTypeMetadata(type);
        }
    }

     public static class MetadataHelper
    {
         public static List<TypeMetadata> GetTypeMetadata(string type)
        {
            var types = Assembly.LoadFrom(type).GetTypes();

            var result = new List<TypeMetadata>();

            foreach (var typeToInspect in types)
            {
                var metadata = new TypeMetadata() { Name = typeToInspect.Name, Methods = new List<MethodMetadata>() };
                metadata.Methods = GetMethods(typeToInspect);

                result.Add(metadata);
            }

            return result;
        }

        private static List<MethodMetadata> GetMethods(Type type)
        {
            var methods = new List<MethodMetadata>();

            foreach (var method in type.GetMethods(BindingFlags.Instance | BindingFlags.Public | BindingFlags.DeclaredOnly))
            {
                var methodMetadata = new MethodMetadata();
                methodMetadata.Name = method.Name;

                methodMetadata.Parameters = method.GetParameters()
                                                    .Select(pInfo => new Argument() { Name = pInfo.Name, Type = pInfo.ParameterType.ToString() }).ToList();
                methodMetadata.ReturnValue = new Argument() { Name = method.ReturnParameter.Name, Type = method.ReturnParameter.ParameterType.ToString() };

                methods.Add(methodMetadata);
            }

            return methods;
        }
    }

    public class TypeMetadata
    {
        public string Name { get; set; }
        public List<MethodMetadata> Methods { get; set; }
    }

    public class MethodMetadata
    {
        public string Name { get; set; }
        public List<Argument> Parameters { get; set; }
        public Argument ReturnValue { get; set; }
    }

    public class Argument
    {
        public string Name { get; set; }
        public string Type { get; set; }
    }

    public class Car
    {
        public string Model { get; set; }
        public string Brand { get; set; }
        public Color ExteriorColor { get; set; }
    }

    public class Color
    {
        public string RGB { get; set; }
        public string Name { get; set; }
    }

    public class ClassWithDictionary
    {
        public string Guid { get; set; }
        public Dictionary<string, string> Runparams { get; set; }
    }

     //public object ExecuteComplex(Person person)
     //   {
     //       MuleContext.Current.Logger.Write("Executing person method: ");
     //       var from = MuleContext.Current.Message.InboundProperties["http.request"];
     //       var updated = MuleContext.Current.Message.InvocationProperties.ContainsKey("update") ? (bool)MuleContext.Current.Message.InvocationProperties["update"] : false;

     //       if (updated)
     //       {
     //           person.Name += " updated from .net";
     //       }
     //       person.MyRide.Brand = person.MyRide.Brand.Replace("GM", "Chevrolet");
     //       person.MyRide.Model = person.MyRide.Model + " - " + "400x";

     //       person.MyRide.ExteriorColor.Name += "ISH";
     //       person.MyRide.ExteriorColor.RGB = "no clue";

     //       MuleContext.Current.Message.SessionProperties["dotnet"] = System.Text.Encoding.UTF8.GetBytes("Cheers from .Net! : " + from + " : " + System.Threading.Thread.CurrentThread.ManagedThreadId.ToString());

     //       return person;
     //   }
}
