import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;
import org.mule.api.context.notification.ServerNotification;
import org.mule.modules.dotnet.instrumentation.DotNetConnectorNotificationListener;


public class DotNetListener extends DotNetConnectorNotificationListener {
	
	private static final Logger LOGGER = Logger.getLogger(DotNetListener.class);
	
	@Override
	public void onNotification(ServerNotification notification) 
	{
		Timestamp timestamp = new Timestamp(notification.getTimestamp());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy  HH:mm:ss:S");

		String info = String.format("%s: %s", notification.getActionName(), simpleDateFormat.format(timestamp));
		LOGGER.info(info);
	}
}
