[Reflection.Assembly]::LoadWithPartialName("System.Messaging") | out-null 

# Creates an MSMQ Queue
Function CreateQueue
{
  param
  (
    [string]$path,
    [string]$label
  )


    Write-Host "Creating $path Queue"

    if ([System.Messaging.MessageQueue]::Exists($path))
    {
        [System.Messaging.MessageQueue]::Delete($path)
    }

    $qb = [System.Messaging.MessageQueue]::Create($path)
      
    $qb.SetPermissions("Everyone", [System.Messaging.MessageQueueAccessRights]::FullControl, [System.Messaging.AccessControlEntryType]::Allow) 

    $qb.Label = $label
}

#Sends Message
Function SendMessage
{
    param
    (
        [string] $queue,
        [System.Messaging.Message] $msg,
        [System.Boolean] $useTransaction
    )
    $label = $msg.Label
    Write-Host "Sending $label to $queue"
    $msg.AdministrationQueue = new-object System.Messaging.MessageQueue ".\private$\adminq"
    $ackType = [System.Messaging.AcknowledgeTypes]
    $msg.AcknowledgeType = $ackType::FullReachQueue -bor $ackType::FullReceive -bor $ackType::NegativeReceive -bor $ackType::NotAcknowledgeReachQueue -bor $ackType::NotAcknowledgeReceive -bor $ackType::PositiveArrival -bor $ackType::PositiveReceive

    $q = new-object System.Messaging.MessageQueue $queue
    if ($useTransaction)
    {
        $q.Send($msg, [System.Messaging.MessageQueueTransactionType]::Single)
    } 
    else
    {
        $q.Send($msg)
    }
    

}


#1 Create Queues

CreateQueue ".\private$\sampleq" "private$\sampleq"
CreateQueue ".\private$\secondq" "private$\secondq"
CreateQueue ".\private$\adminq" "private$\adminq"

# Messages

# 1st Will be sent to a normal queue
  $msg = new-object System.Messaging.Message "First Message"
  $msg.Label = "Message 1"
  SendMessage ".\private$\sampleq" $msg

# 2nd Will be sent to a queue without enough quota
  $msg = new-object System.Messaging.Message "Second Message"
  $msg.Label = "Message 2"
  SendMessage ".\private$\secondq" $msg

# 3rd Will be sent in transactional way to a non-transactional queue
  $msg = new-object System.Messaging.Message "Third Message"
  $msg.Label = "Message 3"
  SendMessage ".\private$\sampleq" $msg $true

# 4th Will be sent with very small time to be received producing a time-out
  $msg = new-object System.Messaging.Message "Fourth Message"
  $msg.Label = "Message 4"
  $msg.TimeToBeReceived = New-Object System.TimeSpan 0,0,0,0,1
  $msg.TimeToReachQueue = New-Object System.TimeSpan 0,0,0,0,1
  SendMessage ".\private$\sampleq" $msg

