/*
 * Decompiled with CFR 0.152.
 */
package org.mule.galaxy.security.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.galaxy.NotFoundException;
import org.mule.galaxy.impl.jcr.UserDetailsWrapper;
import org.mule.galaxy.security.AccessControlManager;
import org.mule.galaxy.security.Group;
import org.mule.galaxy.security.User;
import org.mule.galaxy.security.ldap.AuthenticationWrapper;
import org.mule.galaxy.security.ldap.LdapAuthenticationProvider;
import org.mule.galaxy.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.authentication.LdapAuthenticator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalaxyAuthenticationProvider
extends LdapAuthenticationProvider {
    private final Log log = LogFactory.getLog(this.getClass());
    private AccessControlManager accessControlManager;
    private ContextMapper userMapper;
    private List<String> requiredAuthorities;

    public GalaxyAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        super(authenticator, (org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator)authoritiesPopulator);
    }

    public void setAccessControlManager(AccessControlManager accessControlManager) {
        this.accessControlManager = accessControlManager;
    }

    public void setUserMapper(ContextMapper userMapper) {
        this.userMapper = userMapper;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (this.requiredAuthorities != null && !this.requiredAuthorities.isEmpty()) {
            Collection authorities = userDetails.getAuthorities();
            boolean found = false;
            if (authorities != null) {
                block0: for (GrantedAuthority auth : authorities) {
                    for (String requiredAuthority : this.requiredAuthorities) {
                        if (!auth.getAuthority().equals(requiredAuthority)) continue;
                        found = true;
                        continue block0;
                    }
                }
            }
            if (!found) {
                throw new AuthenticationCredentialsNotFoundException("User does not have sufficient authority.");
            }
        }
    }

    @Override
    protected Authentication createSuccessfulAuthentication(UsernamePasswordAuthenticationToken authentication, UserDetails userDetails, DirContextOperations userData) {
        UsernamePasswordAuthenticationToken successfulAuthentication = (UsernamePasswordAuthenticationToken)super.createSuccessfulAuthentication(authentication, userDetails, userData);
        User user = (User)this.userMapper.mapFromContext((Object)userData);
        UserDetailsWrapper userDetailsWrapper = new UserDetailsWrapper(user, null, successfulAuthentication.getCredentials().toString());
        userDetailsWrapper.setAuthorities(successfulAuthentication.getAuthorities().toArray(new GrantedAuthority[successfulAuthentication.getAuthorities().size()]));
        HashSet<Group> galaxyGroups = new HashSet<Group>();
        for (GrantedAuthority authority : successfulAuthentication.getAuthorities()) {
            try {
                galaxyGroups.add(this.accessControlManager.getGroupByName(authority.toString()));
            }
            catch (NotFoundException ex) {
                this.log.warn((Object)("Galaxy group not found " + authority.toString()));
            }
        }
        userDetailsWrapper.getUser().setGroups(galaxyGroups);
        userDetailsWrapper.setPermissions(this.accessControlManager.getGrantedPermissions(user));
        this.additionalAuthenticationChecks((UserDetails)userDetailsWrapper, successfulAuthentication);
        return new AuthenticationWrapper((Authentication)successfulAuthentication, userDetailsWrapper);
    }

    public void setRequiredAuthorities(List<String> requiredAuthorities) {
        this.requiredAuthorities = requiredAuthorities;
    }
}

