/*
 * Decompiled with CFR 0.152.
 */
package org.mule.galaxy.security.ldap;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.galaxy.security.AccessControlManager;
import org.mule.galaxy.security.Group;
import org.springframework.ldap.core.ContextSource;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;

public class LdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private AccessControlManager accessControlManager;

    public LdapAuthoritiesPopulator(ContextSource initialDirContextFactory, String groupSearchBase) {
        super(initialDirContextFactory, groupSearchBase);
    }

    public void setAccessControlManager(AccessControlManager accessControlManager) {
        this.accessControlManager = accessControlManager;
    }

    public Set getGroupMembershipRoles(String userDn, String username) {
        Object[] ldapAuthorities = super.getGroupMembershipRoles(userDn, username).toArray();
        HashSet<Object> commonGroups = new HashSet<Object>();
        block0: for (Group galaxyGroup : this.accessControlManager.getGroups()) {
            for (Object grantedAuthority : ldapAuthorities) {
                if (!galaxyGroup.getName().equals(grantedAuthority.toString())) continue;
                commonGroups.add(grantedAuthority);
                continue block0;
            }
        }
        this.log.debug((Object)("Group intersection " + commonGroups));
        return commonGroups;
    }
}

