import com.mulesoft.console.Permissions;
import org.mule.galaxy.Item
import org.mule.galaxy.Registry
import org.mule.galaxy.Results;
import org.mule.galaxy.util.SecurityUtils
import org.mule.galaxy.impl.jcr.JcrUtil
import org.mule.galaxy.query.Query
import org.mule.galaxy.query.SearchResults

import org.springframework.context.ApplicationContext
import org.springmodules.jcr.JcrCallback
import java.util.concurrent.*
import java.util.*;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.Property;
import javax.jcr.Value;

def TIME_OUT = 600 // the number of seconds after which the script will timeout. Increase/decrease this value if your database is big/small

def sf = applicationContext.getBean("sessionFactory")
def passwordEncoder = applicationContext.getBean("passwordEncoder")

def Callable updateCallable = {
	SecurityUtils.doPrivileged({
		JcrUtil.doInTransaction(sf, {
			session ->
            def qm =  session.getWorkspace().getQueryManager();
            javax.jcr.query.Query query = qm.createQuery("/jcr:root/users/*", javax.jcr.query.Query.XPATH);
            QueryResult qr = query.execute();		
            NodeIterator iterator = qr.getNodes();	
            
            while(iterator.hasNext()) {
                try {
                    javax.jcr.Node bla = iterator.nextNode();
                    Property property = bla.getProperty("password");                    
                    def newPassword = passwordEncoder.encodePassword(property.getValue().getString(),'')
                    property.setValue(newPassword)
                } catch (Exception e) {
                    println(e);
                    continue;
                }
            }			
            session.save()
            println(">>>>>>>>>>> Passwords updated successfully ")
		} as JcrCallback)
	})
} as Callable
def executor = Executors.newSingleThreadExecutor()
try {
	executor.submit(updateCallable).get(TIME_OUT, TimeUnit.SECONDS)
} catch (ExecutionException e) {
	throw e?.cause?.cause
}
return "Success"