/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.encryption.binary.jce;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mule.security.encryption.MuleEncryptionException;
import org.mule.security.encryption.binary.Encrypter;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionAlgorithm;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionMode;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionPadding;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;

public class JCEEncrypter
implements Encrypter {
    protected EncryptionAlgorithm encryptionAlgorithm;
    protected EncryptionMode encryptionMode;
    protected EncryptionPadding encryptionPadding;
    private EncryptionKeyFactory keyFactory;

    public JCEEncrypter(EncryptionAlgorithm encryptionAlgorithm, EncryptionMode encryptionMode, EncryptionPadding encryptionPadding, EncryptionKeyFactory keyFactory) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptionMode = encryptionMode;
        this.encryptionPadding = encryptionPadding;
        this.keyFactory = keyFactory;
    }

    @Override
    public byte[] encrypt(byte[] data) throws MuleEncryptionException {
        try {
            String xform = this.createXForm();
            Cipher cipher = Cipher.getInstance(xform, "BC");
            Key cipherKey = this.keyFactory.buildEncryptionKey();
            this.runCipher(cipher, cipherKey, 1, this.keyFactory.getPlainKey());
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            return this.handleEncryptionException(e, this.keyFactory.getPlainKey());
        }
    }

    @Override
    public void encrypt(InputStream in, OutputStream out) throws MuleEncryptionException {
        try {
            int numRead;
            String xform = this.createXForm();
            Cipher cipher = Cipher.getInstance(xform);
            Key cipherKey = this.keyFactory.buildEncryptionKey();
            this.runCipher(cipher, cipherKey, 1, this.keyFactory.getPlainKey());
            byte[] buf = new byte[1024];
            out = new CipherOutputStream(out, cipher);
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
            out.close();
        }
        catch (Exception e) {
            this.handleEncryptionException(e, this.keyFactory.getPlainKey());
        }
    }

    @Override
    public byte[] decrypt(byte[] data) throws MuleEncryptionException {
        try {
            String xform = this.createXForm();
            Cipher cipher = Cipher.getInstance(xform);
            Key cipherKey = this.keyFactory.buildDecryptionKey();
            this.runCipher(cipher, cipherKey, 2, this.keyFactory.getPlainKey());
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            return this.handleEncryptionException(e, this.keyFactory.getPlainKey());
        }
    }

    @Override
    public void decrypt(InputStream in, OutputStream out) throws MuleEncryptionException {
        try {
            int numRead;
            String xform = this.createXForm();
            Cipher cipher = Cipher.getInstance(xform);
            Key cipherKey = this.keyFactory.buildDecryptionKey();
            this.runCipher(cipher, cipherKey, 2, this.keyFactory.getPlainKey());
            in = new CipherInputStream(in, cipher);
            byte[] buf = new byte[1024];
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
            out.close();
        }
        catch (Exception e) {
            this.handleEncryptionException(e, this.keyFactory.getPlainKey());
        }
    }

    private String createXForm() {
        return this.encryptionAlgorithm.name() + "/" + this.encryptionMode.name() + "/" + this.encryptionPadding.name();
    }

    private void runCipher(Cipher cipher, Key cipherKey, int mode, String key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.encryptionMode.equals((Object)EncryptionMode.ECB)) {
            cipher.init(mode, cipherKey);
        } else {
            IvParameterSpec ips = new IvParameterSpec(Arrays.copyOfRange(key.getBytes(), 0, this.ivSize()));
            cipher.init(mode, cipherKey, ips);
        }
    }

    private int ivSize() {
        return this.encryptionAlgorithm.getIvSize() == 0 ? 8 : this.encryptionAlgorithm.getIvSize();
    }

    private void checkKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key is null, you need to specify a Key to Decrypt");
        }
    }

    private byte[] handleEncryptionException(Exception e, String key) throws MuleEncryptionException {
        if (e instanceof InvalidAlgorithmParameterException) {
            throw new MuleEncryptionException("This algorithm is not allowed by your current running JVM. You probably need to install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files");
        }
        if (e instanceof InvalidKeyException) {
            if (key.getBytes().length < this.encryptionAlgorithm.minKeySize()) {
                throw new MuleEncryptionException("You need to increment your key size  The minimum allowed key size is: " + this.encryptionAlgorithm.minKeySize() + " But your key size is: " + key.getBytes().length);
            }
            throw new MuleEncryptionException("Your key size exceeds the maximum allowed key size in your JVM.  The maximum allowed key size is: " + this.getMaxKeySize() + " But your key size is: " + key.getBytes().length + " You probably want to install the Java Cryptography Extension (JCE) " + " Unlimited Strength Jurisdiction Policy Files");
        }
        throw new MuleEncryptionException("Could not encrypt the data.", e);
    }

    private int getMaxKeySize() {
        try {
            return Cipher.getMaxAllowedKeyLength(this.encryptionAlgorithm.name()) / 8;
        }
        catch (NoSuchAlgorithmException e) {
            return 0;
        }
    }
}

