/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.encryption.binary.jce.algorithms;

import org.mule.security.encryption.binary.jce.algorithms.EncrypterBuilderFactory;
import org.mule.security.encryption.binary.jce.factories.AsymmetricEncrypterBuilder;
import org.mule.security.encryption.binary.jce.factories.EncrypterBuilder;
import org.mule.security.encryption.binary.jce.factories.SymmetricEncrypterBuilder;

public enum EncryptionAlgorithm {
    AES(16, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    Blowfish(0, 1, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    DES(0, 8, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    DESede(0, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    Camellia(16, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    CAST5(8, 1, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    CAST6(16, 1, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    Noekeon(16, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    Rijndael(16, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    SEED(16, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    Serpent(16, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    Skipjack(8, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    TEA(0, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    Twofish(16, 8, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    XTEA(8, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    RC2(0, 1, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    RC5(0, 1, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    RC6(16, 1, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new SymmetricEncrypterBuilder(algorithm);
        }
    }),
    RSA(0, 16, new EncrypterBuilderFactory(){

        @Override
        public EncrypterBuilder createFor(EncryptionAlgorithm algorithm) {
            return new AsymmetricEncrypterBuilder();
        }
    });

    private int minSize;
    private EncrypterBuilderFactory factory;
    private int ivSize;

    public int minKeySize() {
        return this.minSize;
    }

    private EncryptionAlgorithm(int ivSize, int minSize, EncrypterBuilderFactory factory) {
        this.minSize = minSize;
        this.factory = factory;
        this.ivSize = ivSize;
    }

    public EncrypterBuilder getBuilder() {
        return this.factory.createFor(this);
    }

    public int getIvSize() {
        return this.ivSize;
    }
}

