/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.encryption.binary.jce.factories;

import org.mule.security.encryption.binary.Encrypter;
import org.mule.security.encryption.binary.jce.JCEEncrypter;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionAlgorithm;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionPadding;
import org.mule.security.encryption.binary.jce.factories.EncrypterBuilder;
import org.mule.security.utils.keyfactories.KeystoreEncryptionKeyFactory;
import org.mule.security.utils.keyfactories.SymmetricEncryptionKeyFactory;

public class SymmetricEncrypterBuilder
extends EncrypterBuilder {
    private EncryptionAlgorithm encryptionAlgorithm;

    public SymmetricEncrypterBuilder(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    @Override
    public Encrypter build() {
        if (this.keystorePath != null) {
            return new JCEEncrypter(this.encryptionAlgorithm, this.mode, EncryptionPadding.PKCS5Padding, new KeystoreEncryptionKeyFactory(this.keystorePath, this.keystorePassword, this.keyPassword, this.key, true));
        }
        return new JCEEncrypter(this.encryptionAlgorithm, this.mode, EncryptionPadding.PKCS5Padding, new SymmetricEncryptionKeyFactory(this.encryptionAlgorithm.name(), this.key));
    }
}

