/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.data;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Mac;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.mule.security.signature.data.Signer;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;

public class HMACSigner
implements Signer {
    private String signatureAlgorithm;
    private EncryptionKeyFactory factory;

    public HMACSigner(String signatureAlgorithm, EncryptionKeyFactory factory) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.factory = factory;
    }

    @Override
    public String sign(byte[] data) {
        try {
            Key secretKey = this.factory.buildEncryptionKey();
            Mac mac = Mac.getInstance(this.signatureAlgorithm);
            mac.init(secretKey);
            byte[] hmacData = mac.doFinal(data);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            new Base64Encoder().encode(hmacData, 0, hmacData.length, (OutputStream)bout);
            return bout.toString("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not sign your data", e);
        }
    }

    @Override
    public String sign(InputStream stream) {
        try {
            Key secretKey = this.factory.buildEncryptionKey();
            Mac mac = Mac.getInstance(this.signatureAlgorithm);
            mac.init(secretKey);
            byte[] buffer = new byte[1024];
            int read = -1;
            while (stream.available() > 0) {
                read = stream.read(buffer, 0, buffer.length);
                mac.update(buffer, 0, read);
            }
            byte[] hmacData = mac.doFinal();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            new Base64Encoder().encode(hmacData, 0, hmacData.length, (OutputStream)bout);
            return bout.toString("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not sign your data", e);
        }
    }

    @Override
    public boolean validateSignature(byte[] data, String expectedSignature) {
        String signature = this.sign(data);
        return signature.equals(expectedSignature);
    }

    @Override
    public boolean validateSignature(InputStream stream, String expectedSignature) {
        String signature = this.sign(stream);
        return signature.equals(expectedSignature);
    }
}

