/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.keyinfo;

import java.security.Key;
import java.util.Collections;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.algorithms.CanonicalizationAlgorithm;
import org.mule.security.signature.xml.algorithms.SignatureMethodAlgorithm;
import org.mule.security.signature.xml.keyinfo.KeyInfoProvider;

public class SecretKeyInfoProvider
implements KeyInfoProvider {
    private String secretKey;
    private String secretKeyAlgorithm;
    private CanonicalizationAlgorithm canonicalizationAlgorithm;

    public SecretKeyInfoProvider(String secretKey, String secretKeyAlgorithm, CanonicalizationAlgorithm canonicalizationAlgorithm) {
        this.secretKey = secretKey;
        this.secretKeyAlgorithm = secretKeyAlgorithm;
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
    }

    @Override
    public KeyInfo getKeyInfo() {
        return null;
    }

    @Override
    public Key getSecretKey() {
        return new SecretKeySpec(this.secretKey.getBytes(), this.secretKeyAlgorithm);
    }

    @Override
    public SignedInfo getSignedInfo(Reference ref) {
        try {
            return Signer.fac.newSignedInfo(Signer.fac.newCanonicalizationMethod(this.canonicalizationAlgorithm.getAlgorithm(), (C14NMethodParameterSpec)null), Signer.fac.newSignatureMethod(SignatureMethodAlgorithm.HMAC_SHA1.getAlgorithm(), null), Collections.singletonList(ref));
        }
        catch (Exception e) {
            throw new RuntimeException("Signed Info could not be created", e);
        }
    }
}

