/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.validator;

import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.validator.SignatureValidator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DefaultSignatureValidator
implements SignatureValidator {
    private KeySelector keySelector;

    public DefaultSignatureValidator(KeySelector keySelector) {
        this.keySelector = keySelector;
    }

    @Override
    public boolean validate(Document doc) throws MarshalException, XMLSignatureException {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new RuntimeException("Cannot find Signature element");
        }
        DOMValidateContext valContext = new DOMValidateContext(this.keySelector, nl.item(0));
        XMLSignature signature = Signer.fac.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }
}

