/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.utils.keyfactories;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;
import org.mule.util.IOUtils;

public class KeystoreEncryptionKeyFactory
implements EncryptionKeyFactory {
    private KeyStore ks;
    private String password;
    private boolean symmetric;
    private String keyPassword;
    private String key;

    public KeystoreEncryptionKeyFactory(String keystore, String password, String keyPassword, String key, boolean symmetric) {
        try {
            this.key = key;
            this.password = password;
            this.symmetric = symmetric;
            this.keyPassword = keyPassword;
            this.validateKeystoreParameters();
            this.ks = KeyStore.getInstance(symmetric ? "JCEKS" : "JKS");
            this.ks.load(IOUtils.getResourceAsStream((String)keystore, this.getClass()), password.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read the Keystore", e);
        }
    }

    private void validateKeystoreParameters() {
        if (this.password == null) {
            throw new IllegalArgumentException("If keystore is defined then the keystore password must be defined");
        }
        if (this.key == null) {
            throw new IllegalArgumentException("If keystore is defined then the key must be defined");
        }
        if (this.keyPassword == null) {
            throw new IllegalArgumentException("If keystore is defined then the key password must be defined");
        }
    }

    @Override
    public Key buildEncryptionKey() {
        try {
            return this.ks.getKey(this.key, this.keyPassword.toCharArray());
        }
        catch (UnrecoverableKeyException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Key buildDecryptionKey() {
        Key privateKey = this.buildEncryptionKey();
        if (privateKey instanceof PrivateKey && !this.symmetric) {
            Certificate cert = null;
            try {
                cert = this.ks.getCertificate(this.key);
                return cert.getPublicKey();
            }
            catch (KeyStoreException e) {
                return privateKey;
            }
        }
        return privateKey;
    }

    @Override
    public String getPlainKey() {
        return this.key;
    }
}

