/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption;

import javax.annotation.PostConstruct;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageExtension;
import org.mule.modules.security.encryption.EncrypterType;
import org.mule.modules.security.encryption.encrypters.JCEEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.JCEEncrypterModule;
import org.mule.modules.security.encryption.encrypters.JCEEncrypterOverrideConfiguration;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterModule;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterOverrideConfiguration;
import org.mule.modules.security.encryption.encrypters.XmlEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.XmlEncrypterModule;
import org.mule.modules.security.encryption.encrypters.XmlEncrypterOverrideConfiguration;
import org.mule.modules.security.encryption.language.ModuleWrapper;
import org.mule.security.encryption.MuleEncryptionException;
import org.springframework.beans.factory.BeanNameAware;

public class EncryptionModule
implements BeanNameAware,
ExpressionLanguageExtension {
    private String referenceName;
    private EncrypterType defaultEncrypter;
    private boolean enableLanguage;
    private XmlEncrypterConfiguration xmlEncrypterConfig;
    private JCEEncrypterConfiguration jceEncrypterConfig;
    private PGPEncrypterConfiguration pgpEncrypterConfig;

    @PostConstruct
    public void setDefaults() {
        if (this.jceEncrypterConfig == null) {
            this.jceEncrypterConfig = JCEEncrypterConfiguration.getDefaultConfiguration();
        } else {
            this.jceEncrypterConfig.setDefaults();
        }
        if (this.xmlEncrypterConfig == null) {
            this.xmlEncrypterConfig = XmlEncrypterConfiguration.getDefaultConfiguration();
        } else {
            this.xmlEncrypterConfig.setDefaults();
        }
        if (this.pgpEncrypterConfig == null) {
            this.pgpEncrypterConfig = PGPEncrypterConfiguration.getDefaultConfiguration();
        }
    }

    public Object encrypt(Object input, EncrypterType using, JCEEncrypterOverrideConfiguration jceEncrypter, XmlEncrypterOverrideConfiguration xmlEncrypter, PGPEncrypterOverrideConfiguration pgpEncrypter) throws MuleEncryptionException {
        EncrypterType type = this.getStrategy(using, jceEncrypter, xmlEncrypter, pgpEncrypter);
        if (EncrypterType.JCE_ENCRYPTER.equals((Object)type)) {
            return new JCEEncrypterModule(this.jceEncrypterConfig, jceEncrypter).encrypt(input);
        }
        if (EncrypterType.XML_ENCRYPTER.equals((Object)type)) {
            return new XmlEncrypterModule(this.xmlEncrypterConfig, xmlEncrypter).encrypt((String)input);
        }
        return new PGPEncrypterModule(this.pgpEncrypterConfig, pgpEncrypter).encrypt(input);
    }

    public Object decrypt(Object input, EncrypterType using, JCEEncrypterOverrideConfiguration jceEncrypter, XmlEncrypterOverrideConfiguration xmlEncrypter, PGPEncrypterOverrideConfiguration pgpEncrypter) throws MuleEncryptionException {
        EncrypterType type = this.getStrategy(using, jceEncrypter, xmlEncrypter, pgpEncrypter);
        if (EncrypterType.JCE_ENCRYPTER.equals((Object)type)) {
            return new JCEEncrypterModule(this.jceEncrypterConfig, jceEncrypter).decrypt(input);
        }
        if (EncrypterType.XML_ENCRYPTER.equals((Object)type)) {
            return new XmlEncrypterModule(this.xmlEncrypterConfig, xmlEncrypter).decrypt((String)input);
        }
        return new PGPEncrypterModule(this.pgpEncrypterConfig, pgpEncrypter).decrypt(input);
    }

    public void configureContext(ExpressionLanguageContext context) {
        if (this.enableLanguage) {
            if (this.referenceName != null) {
                context.addVariable(this.referenceName, (Object)new ModuleWrapper(this));
            } else {
                throw new IllegalArgumentException("If you want to enable language encryption you need to provide a module name");
            }
        }
    }

    public void setBeanName(String name) {
        this.referenceName = name;
    }

    private EncrypterType getStrategy(EncrypterType using, JCEEncrypterOverrideConfiguration jceStrategy, XmlEncrypterOverrideConfiguration xmlStrategy, PGPEncrypterOverrideConfiguration pgpStrategy) {
        if (jceStrategy != null) {
            return EncrypterType.JCE_ENCRYPTER;
        }
        if (xmlStrategy != null) {
            return EncrypterType.XML_ENCRYPTER;
        }
        if (pgpStrategy != null) {
            return EncrypterType.PGP_ENCRYPTER;
        }
        if (using != null) {
            return using;
        }
        return this.defaultEncrypter;
    }

    public void setEnableLanguage(boolean enableLanguage) {
        this.enableLanguage = enableLanguage;
    }

    public boolean isEnableLanguage() {
        return this.enableLanguage;
    }

    public JCEEncrypterConfiguration getJceEncrypterConfig() {
        return this.jceEncrypterConfig;
    }

    public void setJceEncrypterConfig(JCEEncrypterConfiguration jceEncrypterConfig) {
        this.jceEncrypterConfig = jceEncrypterConfig;
    }

    public XmlEncrypterConfiguration getXmlEncrypterConfig() {
        return this.xmlEncrypterConfig;
    }

    public void setXmlEncrypterConfig(XmlEncrypterConfiguration xmlEncrypterConfig) {
        this.xmlEncrypterConfig = xmlEncrypterConfig;
    }

    public EncrypterType getDefaultEncrypter() {
        return this.defaultEncrypter;
    }

    public void setDefaultEncrypter(EncrypterType defaultEncrypter) {
        this.defaultEncrypter = defaultEncrypter;
    }

    public PGPEncrypterConfiguration getPgpEncrypterConfig() {
        return this.pgpEncrypterConfig;
    }

    public void setPgpEncrypterConfig(PGPEncrypterConfiguration pgpEncrypterConfig) {
        this.pgpEncrypterConfig = pgpEncrypterConfig;
    }
}

