/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.mule.api.MuleEvent;
import org.mule.api.callback.SourceCallback;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageExtension;
import org.mule.api.expression.ExpressionManager;
import org.mule.module.signature.SignatureEnricher;
import org.mule.module.signature.SignatureModuleType;
import org.mule.module.signature.language.SignatureModuleWrapper;
import org.mule.module.signature.signers.JCESignerConfiguration;
import org.mule.module.signature.signers.JCESignerModule;
import org.mule.module.signature.signers.JCESignerOverrideConfiguration;
import org.mule.module.signature.signers.XmlSignerConfiguration;
import org.mule.module.signature.signers.XmlSignerModule;
import org.mule.module.signature.signers.XmlSignerOverrideConfiguration;
import org.mule.security.signature.xml.SignatureType;
import org.mule.security.signature.xml.algorithms.CanonicalizationAlgorithm;
import org.mule.security.signature.xml.algorithms.DigestMethodAlgorithm;
import org.mule.security.signature.xml.algorithms.SignatureMethodAlgorithm;
import org.mule.transport.NullPayload;
import org.springframework.beans.factory.BeanNameAware;

public class SignatureModule
implements BeanNameAware,
ExpressionLanguageExtension {
    @Inject
    private ExpressionManager expressionManager;
    private boolean enableLanguage;
    private JCESignerConfiguration jceSignerConfig;
    private XmlSignerConfiguration xmlSignerConfig;
    private SignatureModuleType defaultSigner;
    private String referenceName;

    @PostConstruct
    public void setDefaults() {
        if (this.jceSignerConfig == null) {
            this.jceSignerConfig = JCESignerConfiguration.getDefaultConfiguration();
        } else {
            this.jceSignerConfig.setDefaults();
        }
        if (this.xmlSignerConfig == null) {
            this.xmlSignerConfig = XmlSignerConfiguration.getDefaultConfiguration();
        } else {
            this.xmlSignerConfig.setDefaults();
        }
    }

    @Inject
    public Object sign(Object input, String variable, JCESignerOverrideConfiguration jceSigner, MuleEvent event) {
        SignatureEnricher signatureEnricher = new SignatureEnricher(event, this.expressionManager, variable == null ? "#[variable:signature]" : "#[variable:" + variable + "]");
        return new JCESignerModule(this.jceSignerConfig, jceSigner, signatureEnricher).enrichSignature(input);
    }

    public String signXml(String input, DigestMethodAlgorithm digestMethodAlgorithm, CanonicalizationAlgorithm canonicalizationAlgorithm, SignatureMethodAlgorithm signatureMethodAlgorithm, SignatureType signatureType, String referenceUri, String key, String keyPassword) {
        XmlSignerOverrideConfiguration overrideConfig = new XmlSignerOverrideConfiguration();
        overrideConfig.setCanonicalizationAlgorithm(canonicalizationAlgorithm);
        overrideConfig.setKey(key);
        overrideConfig.setDigestMethodAlgorithm(digestMethodAlgorithm);
        overrideConfig.setSignatureMethodAlgorithm(signatureMethodAlgorithm);
        overrideConfig.setSignatureType(signatureType);
        overrideConfig.setReferenceUri(referenceUri);
        overrideConfig.setKeyPassword(keyPassword);
        return new XmlSignerModule(this.xmlSignerConfig, overrideConfig).sign(input);
    }

    @Inject
    public MuleEvent verifySignature(Object input, SignatureModuleType using, JCESignerOverrideConfiguration jceSigner, XmlSignerOverrideConfiguration xmlSigner, String expectedSignature, MuleEvent muleEvent, SourceCallback afterChain) throws Exception {
        SignatureModuleType type = this.getType(using);
        if (SignatureModuleType.JCE_SIGNER.equals((Object)type)) {
            return this.handle(new JCESignerModule(this.jceSignerConfig, jceSigner).doVerifySignature(input, expectedSignature), muleEvent, afterChain);
        }
        return this.handle(new XmlSignerModule(this.xmlSignerConfig, xmlSigner).doValidateSignature((String)input), muleEvent, afterChain);
    }

    public void configureContext(ExpressionLanguageContext context) {
        if (this.enableLanguage) {
            if (this.referenceName != null) {
                context.addVariable(this.referenceName, (Object)new SignatureModuleWrapper(this));
            } else {
                throw new IllegalArgumentException("If you want to enable language encryption you need to provide a module name");
            }
        }
    }

    private SignatureModuleType getType(SignatureModuleType using) {
        SignatureModuleType type = this.defaultSigner;
        if (using != null) {
            type = using;
        }
        return type;
    }

    private MuleEvent handle(boolean isValid, MuleEvent muleEvent, SourceCallback afterChain) throws Exception {
        if (isValid) {
            return afterChain.processEvent(muleEvent);
        }
        muleEvent.getMessage().setPayload((Object)NullPayload.getInstance());
        return muleEvent;
    }

    public void setBeanName(String name) {
        this.referenceName = name;
    }

    public void setEnableLanguage(boolean enableLanguage) {
        this.enableLanguage = enableLanguage;
    }

    public boolean isEnableLanguage() {
        return this.enableLanguage;
    }

    public JCESignerConfiguration getJceSignerConfig() {
        return this.jceSignerConfig;
    }

    public void setJceSignerConfig(JCESignerConfiguration jceSignerConfig) {
        this.jceSignerConfig = jceSignerConfig;
    }

    public XmlSignerConfiguration getXmlSignerConfig() {
        return this.xmlSignerConfig;
    }

    public void setXmlSignerConfig(XmlSignerConfiguration xmlSignerConfig) {
        this.xmlSignerConfig = xmlSignerConfig;
    }

    public SignatureModuleType getDefaultSigner() {
        return this.defaultSigner;
    }

    public void setDefaultSigner(SignatureModuleType defaultSigner) {
        this.defaultSigner = defaultSigner;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

