/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.signers;

import javax.xml.crypto.KeySelector;
import org.mule.module.signature.signers.XmlSignerConfiguration;
import org.mule.module.signature.signers.XmlSignerOverrideConfiguration;
import org.mule.security.signature.xml.SignatureType;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.algorithms.CanonicalizationAlgorithm;
import org.mule.security.signature.xml.algorithms.DigestMethodAlgorithm;
import org.mule.security.signature.xml.algorithms.SignatureMethodAlgorithm;
import org.mule.security.signature.xml.keyinfo.KeyInfoProvider;
import org.mule.security.signature.xml.keyinfo.KeyPairInfoProvider;
import org.mule.security.signature.xml.keyinfo.X509KeyInfoProvider;
import org.mule.security.signature.xml.reference.DetachedReferenceProvider;
import org.mule.security.signature.xml.reference.EnvelopedReferenceProvider;
import org.mule.security.signature.xml.reference.EnvelopingReferenceProvider;
import org.mule.security.signature.xml.reference.ReferenceProvider;
import org.mule.security.signature.xml.validator.DefaultSignatureValidator;
import org.mule.security.signature.xml.validator.selector.KeyValueKeySelector;
import org.mule.security.signature.xml.validator.selector.X509KeySelector;
import org.mule.security.utils.XMLUtils;
import org.w3c.dom.Document;

public class XmlSignerModule {
    private XmlSignerConfiguration defaultConfiguration;
    private XmlSignerOverrideConfiguration overrideConfiguration;

    public XmlSignerModule(XmlSignerConfiguration defaultConfiguration, XmlSignerOverrideConfiguration overrideConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
    }

    public String sign(String xml) {
        Document doc = XMLUtils.documentBasedOnThe((String)xml);
        SignatureType signatureType = this.signatureType();
        DigestMethodAlgorithm digestMethodAlgorithm = this.digestMethodAlgorithm();
        if (signatureType.equals((Object)SignatureType.ENVELOPED)) {
            new Signer(this.keyInfoProvider(), (ReferenceProvider)new EnvelopedReferenceProvider(digestMethodAlgorithm)).sign(doc);
        } else if (signatureType.equals((Object)SignatureType.ENVELOPING)) {
            new Signer(this.keyInfoProvider(), (ReferenceProvider)new EnvelopingReferenceProvider(digestMethodAlgorithm)).sign(doc);
        } else {
            new Signer(this.keyInfoProvider(), (ReferenceProvider)new DetachedReferenceProvider(digestMethodAlgorithm, this.getReferenceUri())).sign(doc);
        }
        String signedXml = XMLUtils.createXmlUsing((Document)doc);
        return signedXml;
    }

    private DigestMethodAlgorithm digestMethodAlgorithm() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getDigestMethodAlgorithm() != null) {
            return this.overrideConfiguration.getDigestMethodAlgorithm();
        }
        return this.defaultConfiguration.getDigestMethodAlgorithm();
    }

    private SignatureType signatureType() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getSignatureType() != null) {
            return this.overrideConfiguration.getSignatureType();
        }
        return this.defaultConfiguration.getSignatureType();
    }

    private String keystorePath() {
        return this.defaultConfiguration.getKeystorePath();
    }

    private CanonicalizationAlgorithm canonicalizationAlgorithm() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getCanonicalizationAlgorithm() != null) {
            return this.overrideConfiguration.getCanonicalizationAlgorithm();
        }
        return this.defaultConfiguration.getCanonicalizationAlgorithm();
    }

    private SignatureMethodAlgorithm getSignatureMethodAlgorithm() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getSignatureMethodAlgorithm() != null) {
            return this.overrideConfiguration.getSignatureMethodAlgorithm();
        }
        return this.defaultConfiguration.getSignatureMethodAlgorithm();
    }

    private String getKeyPassword() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getKeyPassword() != null) {
            return this.overrideConfiguration.getKeyPassword();
        }
        return this.defaultConfiguration.getKeyPassword();
    }

    private String getReferenceUri() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getReferenceUri() != null) {
            return this.overrideConfiguration.getReferenceUri();
        }
        return this.defaultConfiguration.getReferenceUri();
    }

    private String keyToUse() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getKey() != null) {
            return this.overrideConfiguration.getKey();
        }
        return this.defaultConfiguration.getKey();
    }

    private String keystorePassword() {
        return this.defaultConfiguration.getKeystorePassword();
    }

    private KeyInfoProvider keyInfoProvider() {
        CanonicalizationAlgorithm canonicalizationAlgorithm = this.canonicalizationAlgorithm();
        if (this.keystorePath() != null) {
            return new X509KeyInfoProvider(canonicalizationAlgorithm, this.getSignatureMethodAlgorithm(), this.keystorePath(), this.keystorePassword(), this.keyToUse(), this.getKeyPassword());
        }
        return new KeyPairInfoProvider(canonicalizationAlgorithm, "RSA");
    }

    public boolean doValidateSignature(String xml) {
        try {
            Document doc = XMLUtils.documentBasedOnThe((String)xml);
            if (this.keystorePath() != null) {
                return new DefaultSignatureValidator((KeySelector)new X509KeySelector(this.keystorePath(), this.keystorePassword())).validate(doc);
            }
            DefaultSignatureValidator validator = new DefaultSignatureValidator((KeySelector)new KeyValueKeySelector());
            return validator.validate(doc);
        }
        catch (Exception e) {
            throw new RuntimeException("Error on Validating XML Signature", e);
        }
    }
}

