/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.placeholder;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Base64;
import org.mule.security.encryption.MuleEncryptionException;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionAlgorithm;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionMode;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PreferencesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SecurePropertyPlaceholderModule
extends PreferencesPlaceholderConfigurer {
    private EncryptionAlgorithm encryptionAlgorithm;
    private EncryptionMode encryptionMode;
    private String key;
    private String location;

    public byte[] decrypt(byte[] payload) throws MuleEncryptionException {
        return this.encryptionAlgorithm.getBuilder().using(this.encryptionMode).forKey(this.key).build().decrypt(payload);
    }

    protected String convertPropertyValue(String originalValue) {
        if (originalValue.startsWith("![") && originalValue.endsWith("]")) {
            String propertyKey = originalValue.substring(2, originalValue.length() - 1);
            try {
                return new String(this.decrypt(Base64.decode((String)propertyKey)));
            }
            catch (MuleEncryptionException e) {
                throw new RuntimeException(e);
            }
        }
        return originalValue;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] locations = this.location.split(",");
        ArrayList<ClassPathResource> resources = new ArrayList<ClassPathResource>();
        for (String location : locations) {
            resources.add(new ClassPathResource(location));
        }
        super.setLocations(resources.toArray(new Resource[0]));
        super.postProcessBeanFactory(beanFactory);
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public void setEncryptionMode(EncryptionMode encryptionMode) {
        this.encryptionMode = encryptionMode;
    }

    public void setKey(String key) {
        this.key = this.readEnvironmentalProperties(key);
    }

    public void setLocation(String location) {
        this.location = this.readEnvironmentalProperties(location);
    }

    public String readEnvironmentalProperties(String text) {
        Pattern propertyPatter = Pattern.compile("\\$\\{([^\\}]+)\\}");
        Matcher propertyMatcher = propertyPatter.matcher(text);
        String modifiedText = text;
        while (propertyMatcher.find()) {
            String property = propertyMatcher.group(1);
            modifiedText = this.replaceProperty(modifiedText, property);
        }
        return modifiedText;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public EncryptionMode getEncryptionMode() {
        return this.encryptionMode;
    }

    public String getKey() {
        return this.key;
    }

    public String getLocation() {
        return this.location;
    }

    private String replaceProperty(String modifiedText, String property) {
        String propertyValue = System.getProperty(property);
        this.checkForPropertExistence(property, propertyValue);
        String pattern = "\\$\\{(" + property + ")\\}";
        Pattern replacement = Pattern.compile(pattern);
        Matcher replacementMatcher = replacement.matcher(modifiedText);
        replacementMatcher.find();
        return replacementMatcher.replaceAll(propertyValue);
    }

    private void checkForPropertExistence(String property, String propertyValue) {
        if (propertyValue == null) {
            throw new RuntimeException("Property " + property + " could not be found");
        }
    }
}

