/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.reference;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.algorithms.DigestMethodAlgorithm;
import org.mule.security.signature.xml.reference.ReferenceProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvelopingReferenceProvider
implements ReferenceProvider {
    private DigestMethodAlgorithm digestMethodAlgorithm;

    public EnvelopingReferenceProvider(DigestMethodAlgorithm digestMethodAlgorithm) {
        this.digestMethodAlgorithm = digestMethodAlgorithm;
    }

    @Override
    public Reference getReference() {
        try {
            return Signer.fac.newReference("#AuthenticationObject", Signer.fac.newDigestMethod(this.digestMethodAlgorithm.getAlgorithm(), null));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not getReference Enveloping Reference", e);
        }
    }

    @Override
    public List<Object> getReferencedObjects() {
        ArrayList<Object> objects = new ArrayList<Object>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element authentication = document.createElement("authentication");
            Element nonce = document.createElement("nonce");
            nonce.setTextContent(this.generateNonce());
            authentication.appendChild(nonce);
            Element timestamp = document.createElement("timestamp");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            timestamp.setTextContent(sdf.format(new Date().getTime() - 3600000L));
            authentication.appendChild(timestamp);
            DOMStructure structure = new DOMStructure(authentication);
            objects.add(Signer.fac.newXMLObject(Collections.singletonList(structure), "AuthenticationObject", null, "UTF-8"));
            return objects;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error creating objects", e);
        }
    }

    private String generateNonce() {
        return this.key(32) + "-" + this.key(16) + "-" + this.key(16) + "-" + this.key(16) + "-" + this.key(64);
    }

    private String key(int f) {
        return new BigInteger(f, new SecureRandom()).toString(32);
    }
}

