/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.validator.selector;

import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.mule.security.signature.xml.validator.selector.AlgorithmEqualityChecker;

public class KeyValueKeySelector
extends KeySelector {
    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            throw new KeySelectorException("Null KeyInfo object!");
        }
        SignatureMethod sm = (SignatureMethod)method;
        List<XMLStructure> list = keyInfo.getContent();
        for (int i = 0; i < list.size(); ++i) {
            XMLStructure xmlStructure = list.get(i);
            if (!(xmlStructure instanceof KeyValue)) continue;
            PublicKey pk = null;
            try {
                pk = ((KeyValue)xmlStructure).getPublicKey();
            }
            catch (KeyException ke) {
                throw new KeySelectorException(ke);
            }
            if (!AlgorithmEqualityChecker.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
            return new SimpleKeySelectorResult(pk);
        }
        throw new KeySelectorException("No KeyValue element found!");
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this.pk = pk;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }
}

