/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.encrypters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Base64;
import org.mule.api.MuleEvent;
import org.mule.api.transport.OutputHandler;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterOverrideConfiguration;
import org.mule.security.encryption.MuleEncryptionException;
import org.mule.security.encryption.binary.pgp.PGPEncrypter;

public class PGPEncrypterModule {
    private PGPEncrypterConfiguration defaultConfiguration;
    private PGPEncrypterOverrideConfiguration overrideConfiguration;

    public PGPEncrypterModule(PGPEncrypterConfiguration defaultConfiguration, PGPEncrypterOverrideConfiguration overrideConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
    }

    public Object encrypt(Object input) throws MuleEncryptionException {
        if (input instanceof byte[]) {
            return new PGPEncrypter(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.principal()).encrypt((byte[])input);
        }
        if (input instanceof InputStream) {
            return this.delayEncrypt((InputStream)input);
        }
        if (input instanceof String) {
            return new String(Base64.encode((byte[])new PGPEncrypter(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.principal()).encrypt(((String)input).getBytes())));
        }
        throw new RuntimeException("Could not encrypt the input. The input has to be a byte array,Input Stream or String");
    }

    public Object decrypt(Object input) throws MuleEncryptionException {
        if (input instanceof byte[]) {
            return new PGPEncrypter(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.principal()).decrypt((byte[])input);
        }
        if (input instanceof InputStream) {
            return this.delayEncrypt((InputStream)input);
        }
        if (input instanceof String) {
            return new String(new PGPEncrypter(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.principal()).decrypt(Base64.decode((String)((String)input))));
        }
        throw new RuntimeException("Could not decrypt the input. The input has to be a byte array,Input Stream or String");
    }

    private Object delayEncrypt(final InputStream input) {
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                try {
                    new PGPEncrypter(PGPEncrypterModule.this.publicKeyFile(), PGPEncrypterModule.this.privateKeyFile(), PGPEncrypterModule.this.aliasId(), PGPEncrypterModule.this.passphrase(), PGPEncrypterModule.this.principal()).encrypt(input, out);
                }
                catch (MuleEncryptionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Object delayDecrypt(final InputStream input, String key, String keyPassword) {
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                try {
                    new PGPEncrypter(PGPEncrypterModule.this.publicKeyFile(), PGPEncrypterModule.this.privateKeyFile(), PGPEncrypterModule.this.aliasId(), PGPEncrypterModule.this.passphrase(), PGPEncrypterModule.this.principal()).decrypt(input, out);
                }
                catch (MuleEncryptionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private String passphrase() {
        return this.defaultConfiguration.getSecretPassphrase();
    }

    private String aliasId() {
        return this.defaultConfiguration.getSecretAliasId();
    }

    private String privateKeyFile() {
        return this.defaultConfiguration.getSecretKeyRingFileName();
    }

    private String principal() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getPrincipal() != null) {
            return this.overrideConfiguration.getPrincipal();
        }
        return this.defaultConfiguration.getPrincipal();
    }

    private String publicKeyFile() {
        return this.defaultConfiguration.getPublicKeyRingFileName();
    }
}

