/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.signers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mule.api.MuleEvent;
import org.mule.api.transport.OutputHandler;
import org.mule.module.signature.SignatureEnricher;
import org.mule.module.signature.signers.JCESignerConfiguration;
import org.mule.module.signature.signers.JCESignerOverrideConfiguration;
import org.mule.security.signature.data.Signer;
import org.mule.security.signature.data.algorithms.DataSignatureAlgorithm;

public class JCESignerModule {
    private JCESignerConfiguration defaultConfiguration;
    private JCESignerOverrideConfiguration overrideConfiguration;
    private SignatureEnricher signatureEnricher;

    public JCESignerModule(JCESignerConfiguration defaultConfiguration, JCESignerOverrideConfiguration overrideConfiguration, SignatureEnricher signatureEnricher) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
        this.signatureEnricher = signatureEnricher;
    }

    public JCESignerModule(JCESignerConfiguration defaultConfiguration, JCESignerOverrideConfiguration overrideConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
    }

    public Object sign(Object input) {
        if (input instanceof byte[]) {
            String signature = this.buildSigner(this.getKeyPassword(), this.keyToUse()).sign((byte[])input);
            return signature;
        }
        if (input instanceof String) {
            String signature = this.buildSigner(this.getKeyPassword(), this.keyToUse()).sign(((String)input).getBytes());
            return signature;
        }
        if (input instanceof InputStream) {
            return this.buildSigner(this.getKeyPassword(), this.keyToUse()).sign((InputStream)input);
        }
        throw new RuntimeException("Could not process the input. The input has to be a byte array, String or InputStream");
    }

    public Object enrichSignature(Object input) {
        if (input instanceof byte[]) {
            String signature = this.buildSigner(this.getKeyPassword(), this.keyToUse()).sign((byte[])input);
            this.enrich(signature);
            return input;
        }
        if (input instanceof String) {
            String signature = this.buildSigner(this.getKeyPassword(), this.keyToUse()).sign(((String)input).getBytes());
            this.enrich(signature);
            return input;
        }
        if (input instanceof InputStream) {
            return this.delaySignature((InputStream)input);
        }
        throw new RuntimeException("Could not process the input. The input has to be a byte array, String or InputStream");
    }

    private Signer buildSigner(String keyPassword, String key) {
        if (this.keystorePath() != null) {
            return this.getAlgorithm().getKeystoreSigner(this.keystorePath(), this.keystorePassword(), keyPassword, key);
        }
        return this.getAlgorithm().getPlainSigner(key);
    }

    private Object delaySignature(final InputStream input) {
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                String signature = JCESignerModule.this.buildSigner(JCESignerModule.this.getKeyPassword(), JCESignerModule.this.keyToUse()).sign(input);
                JCESignerModule.this.enrich(signature);
            }
        };
    }

    private String getKeyPassword() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getKeyPassword() != null) {
            return this.overrideConfiguration.getKeyPassword();
        }
        return this.defaultConfiguration.getKeyPassword();
    }

    private String keyToUse() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getKey() != null) {
            return this.overrideConfiguration.getKey();
        }
        return this.defaultConfiguration.getKey();
    }

    private String keystorePath() {
        return this.defaultConfiguration.getKeystorePath();
    }

    private DataSignatureAlgorithm getAlgorithm() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getAlgorithm() != null) {
            return this.overrideConfiguration.getAlgorithm();
        }
        return this.defaultConfiguration.getAlgorithm();
    }

    public boolean doVerifySignature(Object input, String expectedSignature) {
        if (input instanceof byte[]) {
            return this.buildSigner(this.getKeyPassword(), this.keyToUse()).validateSignature((byte[])input, expectedSignature);
        }
        if (input instanceof String) {
            return this.buildSigner(this.getKeyPassword(), this.keyToUse()).validateSignature(((String)input).getBytes(), expectedSignature);
        }
        if (input instanceof InputStream) {
            return this.buildSigner(this.getKeyPassword(), this.keyToUse()).validateSignature((InputStream)input, expectedSignature);
        }
        throw new RuntimeException("Could not process the input. The input has to be a byte array, String or InputStream");
    }

    private String keystorePassword() {
        return this.defaultConfiguration.getKeystorePassword();
    }

    private void enrich(String signature) {
        if (this.signatureEnricher != null) {
            this.signatureEnricher.enrich(signature);
        }
    }
}

