/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.signers;

import org.mule.security.signature.xml.SignatureType;
import org.mule.security.signature.xml.algorithms.CanonicalizationAlgorithm;
import org.mule.security.signature.xml.algorithms.DigestMethodAlgorithm;
import org.mule.security.signature.xml.algorithms.SignatureMethodAlgorithm;

public class XmlSignerConfiguration {
    private DigestMethodAlgorithm digestMethodAlgorithm;
    private CanonicalizationAlgorithm canonicalizationAlgorithm;
    private SignatureMethodAlgorithm signatureMethodAlgorithm;
    private SignatureType signatureType;
    private String referenceUri;
    private String key;
    private String keystorePath;
    private String keystorePassword;
    private String keyPassword;

    public static XmlSignerConfiguration getDefaultConfiguration() {
        XmlSignerConfiguration configuration = new XmlSignerConfiguration();
        configuration.setCanonicalizationAlgorithm(CanonicalizationAlgorithm.EXCLUSIVE);
        configuration.setDigestMethodAlgorithm(DigestMethodAlgorithm.SHA256);
        configuration.setSignatureMethodAlgorithm(SignatureMethodAlgorithm.RSA_SHA1);
        configuration.setSignatureType(SignatureType.ENVELOPED);
        return configuration;
    }

    public void setDefaults() {
        if (this.signatureType == null) {
            this.signatureType = SignatureType.ENVELOPED;
        }
        if (this.signatureMethodAlgorithm == null) {
            this.signatureMethodAlgorithm = SignatureMethodAlgorithm.RSA_SHA1;
        }
        if (this.canonicalizationAlgorithm == null) {
            this.canonicalizationAlgorithm = CanonicalizationAlgorithm.EXCLUSIVE;
        }
        if (this.digestMethodAlgorithm == null) {
            this.digestMethodAlgorithm = DigestMethodAlgorithm.SHA256;
        }
    }

    public DigestMethodAlgorithm getDigestMethodAlgorithm() {
        return this.digestMethodAlgorithm;
    }

    public void setDigestMethodAlgorithm(DigestMethodAlgorithm digestMethodAlgorithm) {
        this.digestMethodAlgorithm = digestMethodAlgorithm;
    }

    public CanonicalizationAlgorithm getCanonicalizationAlgorithm() {
        return this.canonicalizationAlgorithm;
    }

    public void setCanonicalizationAlgorithm(CanonicalizationAlgorithm canonicalizationAlgorithm) {
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
    }

    public SignatureMethodAlgorithm getSignatureMethodAlgorithm() {
        return this.signatureMethodAlgorithm;
    }

    public void setSignatureMethodAlgorithm(SignatureMethodAlgorithm signatureMethodAlgorithm) {
        this.signatureMethodAlgorithm = signatureMethodAlgorithm;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureType signatureType) {
        this.signatureType = signatureType;
    }

    public String getReferenceUri() {
        return this.referenceUri;
    }

    public void setReferenceUri(String referenceUri) {
        this.referenceUri = referenceUri;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }
}

