/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.config;

import org.mule.modules.security.encryption.config.AbstractDefinitionParser;
import org.mule.modules.security.encryption.encrypters.holders.JCEEncrypterOverrideConfigurationExpressionHolder;
import org.mule.modules.security.encryption.encrypters.holders.PGPEncrypterOverrideConfigurationExpressionHolder;
import org.mule.modules.security.encryption.encrypters.holders.XmlEncrypterOverrideConfigurationExpressionHolder;
import org.mule.modules.security.encryption.processors.EncryptMessageProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class EncryptDefinitionParser
extends AbstractDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)EncryptMessageProcessor.class.getName());
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (this.hasAttribute(element, "input-ref")) {
            if (element.getAttribute("input-ref").startsWith("#")) {
                builder.addPropertyValue("input", (Object)element.getAttribute("input-ref"));
            } else {
                builder.addPropertyValue("input", (Object)("#[registry:" + element.getAttribute("input-ref") + "]"));
            }
        }
        this.parseProperty(builder, element, "using", "using");
        if (!this.parseObjectRef(element, builder, "jce-encrypter", "jceEncrypter")) {
            BeanDefinitionBuilder jceEncrypterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)JCEEncrypterOverrideConfigurationExpressionHolder.class.getName());
            Element jceEncrypterChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"jce-encrypter");
            if (jceEncrypterChildElement != null) {
                this.parseProperty(jceEncrypterBuilder, jceEncrypterChildElement, "key", "key");
                this.parseProperty(jceEncrypterBuilder, jceEncrypterChildElement, "keyPassword", "keyPassword");
                this.parseProperty(jceEncrypterBuilder, jceEncrypterChildElement, "algorithm", "algorithm");
                this.parseProperty(jceEncrypterBuilder, jceEncrypterChildElement, "encryptionMode", "encryptionMode");
                builder.addPropertyValue("jceEncrypter", (Object)jceEncrypterBuilder.getBeanDefinition());
            }
        }
        if (!this.parseObjectRef(element, builder, "xml-encrypter", "xmlEncrypter")) {
            BeanDefinitionBuilder xmlEncrypterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)XmlEncrypterOverrideConfigurationExpressionHolder.class.getName());
            Element xmlEncrypterChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"xml-encrypter");
            if (xmlEncrypterChildElement != null) {
                this.parseProperty(xmlEncrypterBuilder, xmlEncrypterChildElement, "key", "key");
                this.parseProperty(xmlEncrypterBuilder, xmlEncrypterChildElement, "keyPassword", "keyPassword");
                this.parseProperty(xmlEncrypterBuilder, xmlEncrypterChildElement, "xpath", "xpath");
                this.parseProperty(xmlEncrypterBuilder, xmlEncrypterChildElement, "algorithm", "algorithm");
                builder.addPropertyValue("xmlEncrypter", (Object)xmlEncrypterBuilder.getBeanDefinition());
            }
        }
        if (!this.parseObjectRef(element, builder, "pgp-encrypter", "pgpEncrypter")) {
            BeanDefinitionBuilder pgpEncrypterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PGPEncrypterOverrideConfigurationExpressionHolder.class.getName());
            Element pgpEncrypterChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"pgp-encrypter");
            if (pgpEncrypterChildElement != null) {
                this.parseProperty(pgpEncrypterBuilder, pgpEncrypterChildElement, "principal", "principal");
                builder.addPropertyValue("pgpEncrypter", (Object)pgpEncrypterBuilder.getBeanDefinition());
            }
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

