/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.encryption.binary.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CredentialsAccessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.module.pgp.KeyBasedEncryptionStrategy;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.PGPKeyRingImpl;
import org.mule.security.encryption.MuleEncryptionException;
import org.mule.security.encryption.binary.Encrypter;

public class PGPEncrypter
implements Encrypter {
    private PGPKeyRing pgpKeyRing;
    private KeyBasedEncryptionStrategy encryptionStrategy;

    public PGPEncrypter(String publicKeyFile, String privateKeyFile, String aliasId, String passPhrase, final String principal) {
        if (principal == null) {
            throw new IllegalArgumentException("A principal must be defined for PGP encryption");
        }
        this.pgpKeyRing = this.buildPgpKeyRing(publicKeyFile, privateKeyFile, aliasId, passPhrase);
        this.encryptionStrategy = new KeyBasedEncryptionStrategy();
        this.encryptionStrategy.setCheckKeyExpirity(true);
        this.encryptionStrategy.setKeyManager(this.pgpKeyRing);
        this.encryptionStrategy.setCredentialsAccessor(new CredentialsAccessor(){

            public Object getCredentials(MuleEvent event) {
                return principal;
            }

            public void setCredentials(MuleEvent event, Object credentials) {
            }
        });
    }

    @Override
    public byte[] encrypt(byte[] data) throws MuleEncryptionException {
        try {
            InputStream io = this.encryptionStrategy.encrypt((InputStream)new ByteArrayInputStream(data), null);
            return IOUtils.toByteArray((InputStream)io);
        }
        catch (CryptoFailureException e) {
            throw new MuleEncryptionException("Could not encrypt the data", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MuleEncryptionException("Could not encrypt the data", e);
        }
    }

    @Override
    public void encrypt(InputStream in, OutputStream out) throws MuleEncryptionException {
        try {
            IOUtils.copyLarge((InputStream)this.encryptionStrategy.encrypt(in, null), (OutputStream)out);
        }
        catch (IOException e) {
            throw new MuleEncryptionException("Could not encrypt the data", e);
        }
        catch (CryptoFailureException e) {
            throw new MuleEncryptionException("Could not encrypt the data", (Exception)((Object)e));
        }
    }

    @Override
    public byte[] decrypt(byte[] data) throws MuleEncryptionException {
        try {
            InputStream io = this.encryptionStrategy.decrypt((InputStream)new ByteArrayInputStream(data), null);
            return IOUtils.toByteArray((InputStream)io);
        }
        catch (CryptoFailureException e) {
            throw new MuleEncryptionException("Could not encrypt the data", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MuleEncryptionException("Could not encrypt the data", e);
        }
    }

    @Override
    public void decrypt(InputStream in, OutputStream out) throws MuleEncryptionException {
        try {
            IOUtils.copyLarge((InputStream)this.encryptionStrategy.decrypt(in, null), (OutputStream)out);
        }
        catch (IOException e) {
            throw new MuleEncryptionException("Could not encrypt the data", e);
        }
        catch (CryptoFailureException e) {
            throw new MuleEncryptionException("Could not encrypt the data", (Exception)((Object)e));
        }
    }

    private PGPKeyRing buildPgpKeyRing(String publicKeyFile, String privateKeyFile, String aliasId, String passPhrase) {
        try {
            PGPKeyRingImpl pgpKeyRing = new PGPKeyRingImpl();
            pgpKeyRing.setPublicKeyRingFileName(publicKeyFile);
            pgpKeyRing.setSecretKeyRingFileName(privateKeyFile);
            pgpKeyRing.setSecretAliasId(aliasId);
            pgpKeyRing.setSecretPassphrase(passPhrase);
            pgpKeyRing.initialise();
            return pgpKeyRing;
        }
        catch (InitialisationException e) {
            return null;
        }
    }
}

