/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.encryption.xml;

import java.security.Key;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPathAPI;
import org.mule.security.encryption.xml.XmlEncryptionAlgorithm;
import org.mule.security.utils.XMLUtils;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlEncrypter {
    private XmlEncryptionAlgorithm algorithm;
    private EncryptionKeyFactory factory;

    public XmlEncrypter(XmlEncryptionAlgorithm algorithm, EncryptionKeyFactory factory) {
        Init.init();
        this.algorithm = algorithm;
        this.factory = factory;
    }

    public String encrypt(String xml, String element) throws Exception {
        Document document = XMLUtils.documentBasedOnThe(xml);
        Key keyEncryptKey = this.factory.buildEncryptionKey();
        SecretKey symmetricKey = XmlEncrypter.generateSymmetricKey(this.algorithm);
        XMLCipher keyCipher = XMLCipher.getInstance((String)this.algorithm.getWrap());
        keyCipher.init(3, keyEncryptKey);
        EncryptedKey encryptedKey = keyCipher.encryptKey(document, (Key)symmetricKey);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)this.algorithm.getValue());
        xmlCipher.init(1, (Key)symmetricKey);
        EncryptedData encryptedDataElement = xmlCipher.getEncryptedData();
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.add(encryptedKey);
        encryptedDataElement.setKeyInfo(keyInfo);
        NodeList elementsToEncrypt = this.getElement(element, document);
        for (int i = 0; i < elementsToEncrypt.getLength(); ++i) {
            Element item = (Element)elementsToEncrypt.item(i);
            xmlCipher.doFinal(document, item, true);
        }
        return XMLUtils.createXmlUsing(document);
    }

    private NodeList getElement(String xpath, Document document) {
        try {
            if (xpath != null) {
                return XPathAPI.selectNodeList((Node)document, (String)xpath);
            }
            return new NodeSet((Node)document.getDocumentElement());
        }
        catch (TransformerException e) {
            throw new RuntimeException("Invalid xpath");
        }
    }

    public String decrypt(String xml) throws Exception {
        Document document = XMLUtils.documentBasedOnThe(xml);
        String namespaceURI = "http://www.w3.org/2001/04/xmlenc#";
        String localName = "EncryptedData";
        Element encryptedDataElement = (Element)document.getElementsByTagNameNS(namespaceURI, localName).item(0);
        Key keyEncryptKey = this.factory.buildDecryptionKey();
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, null);
        xmlCipher.setKEK(keyEncryptKey);
        xmlCipher.doFinal(document, encryptedDataElement);
        return XMLUtils.createXmlUsing(document);
    }

    public static SecretKey generateSymmetricKey(XmlEncryptionAlgorithm algorithm) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm.getAlgorithm());
        keyGenerator.init(algorithm.getSize());
        return keyGenerator.generateKey();
    }
}

