/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml;

import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import org.mule.security.signature.xml.keyinfo.KeyInfoProvider;
import org.mule.security.signature.xml.reference.ReferenceProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Signer {
    public static XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
    private KeyInfoProvider keyInfoProvider;
    private ReferenceProvider referenceProvider;

    public Signer(KeyInfoProvider keyInfoProvider, ReferenceProvider referenceProvider) {
        this.keyInfoProvider = keyInfoProvider;
        this.referenceProvider = referenceProvider;
    }

    public void sign(Document doc) {
        try {
            XMLSignature signature = fac.newXMLSignature(this.keyInfoProvider.getSignedInfo(this.referenceProvider.getReference()), this.keyInfoProvider.getKeyInfo(), this.referenceProvider.getReferencedObjects(), null, null);
            DOMSignContext signContext = new DOMSignContext(this.keyInfoProvider.getSecretKey(), (Node)doc.getDocumentElement());
            signature.sign(signContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add Signature to the document", e);
        }
    }
}

