/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.validator.selector;

import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.mule.security.signature.xml.validator.selector.AlgorithmEqualityChecker;
import org.mule.util.IOUtils;

public class X509KeySelector
extends KeySelector {
    private KeyStore ks;

    public X509KeySelector(String keystore, String password) {
        try {
            this.ks = KeyStore.getInstance("JKS");
            this.ks.load(IOUtils.getResourceAsStream((String)keystore, this.getClass()), password.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read the keystore", e);
        }
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        SignatureMethod sm = (SignatureMethod)method;
        try {
            if (keyInfo == null || this.ks.size() == 0) {
                return new SimpleKeySelectorResult(null);
            }
            for (XMLStructure kiType : keyInfo.getContent()) {
                X509Data xd;
                SimpleKeySelectorResult ksr;
                if (!(kiType instanceof X509Data) || (ksr = this.x509DataSelect(xd = (X509Data)kiType, sm)) == null) continue;
                return ksr;
            }
        }
        catch (KeyStoreException kse) {
            throw new KeySelectorException(kse);
        }
        return new SimpleKeySelectorResult(null);
    }

    private SimpleKeySelectorResult keyStoreSelect(CertSelector cs) throws KeyStoreException {
        Enumeration<String> aliases = this.ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = this.ks.getCertificate(alias);
            if (cert == null || !cs.match(cert)) continue;
            return new SimpleKeySelectorResult(cert.getPublicKey());
        }
        return null;
    }

    private SimpleKeySelectorResult certSelect(X509Certificate xcert, SignatureMethod sm) throws KeyStoreException {
        boolean[] keyUsage = xcert.getKeyUsage();
        if (keyUsage != null && !keyUsage[0]) {
            return null;
        }
        String alias = this.ks.getCertificateAlias(xcert);
        if (alias != null) {
            PublicKey pk = this.ks.getCertificate(alias).getPublicKey();
            if (AlgorithmEqualityChecker.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) {
                return new SimpleKeySelectorResult(pk);
            }
        }
        return null;
    }

    private String getPKAlgorithmOID(String algURI) {
        if (algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return "1.2.840.10040.4.1";
        }
        if (algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return "1.2.840.113549.1.1";
        }
        return null;
    }

    private SimpleKeySelectorResult x509DataSelect(X509Data xd, SignatureMethod sm) throws KeyStoreException, KeySelectorException {
        String algOID = this.getPKAlgorithmOID(sm.getAlgorithm());
        SimpleKeySelectorResult ksr = null;
        Iterator<?> xi = xd.getContent().iterator();
        while (xi.hasNext()) {
            X509CertSelector xcs;
            ksr = null;
            Object o = xi.next();
            if (o instanceof X509Certificate) {
                X509Certificate xcert = (X509Certificate)o;
                ksr = this.certSelect(xcert, sm);
            } else if (o instanceof X509IssuerSerial) {
                X509IssuerSerial xis = (X509IssuerSerial)o;
                xcs = new X509CertSelector();
                try {
                    xcs.setSubjectPublicKeyAlgID(algOID);
                    xcs.setSerialNumber(xis.getSerialNumber());
                    xcs.setIssuer(new X500Principal(xis.getIssuerName()).getName());
                }
                catch (IOException ioe) {
                    throw new KeySelectorException(ioe);
                }
                ksr = this.keyStoreSelect(xcs);
            } else if (o instanceof String) {
                String sn = (String)o;
                xcs = new X509CertSelector();
                try {
                    xcs.setSubjectPublicKeyAlgID(algOID);
                    xcs.setSubject(new X500Principal(sn).getName());
                }
                catch (IOException ioe) {
                    throw new KeySelectorException(ioe);
                }
                ksr = this.keyStoreSelect(xcs);
            } else {
                if (!(o instanceof byte[])) continue;
                byte[] ski = (byte[])o;
                xcs = new X509CertSelector();
                try {
                    xcs.setSubjectPublicKeyAlgID(algOID);
                }
                catch (IOException ioe) {
                    throw new KeySelectorException(ioe);
                }
                byte[] encodedSki = new byte[ski.length + 2];
                encodedSki[0] = 4;
                encodedSki[1] = (byte)ski.length;
                System.arraycopy(ski, 0, encodedSki, 2, ski.length);
                xcs.setSubjectKeyIdentifier(encodedSki);
                ksr = this.keyStoreSelect(xcs);
            }
            if (ksr == null) continue;
            return ksr;
        }
        return null;
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private final Key key;

        SimpleKeySelectorResult(Key key) {
            this.key = key;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }
}

