/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.config;

import org.mule.config.MuleManifest;
import org.mule.modules.security.encryption.encrypters.holders.JCEEncrypterOverrideConfigurationExpressionHolder;
import org.mule.modules.security.encryption.encrypters.holders.PGPEncrypterOverrideConfigurationExpressionHolder;
import org.mule.modules.security.encryption.encrypters.holders.XmlEncrypterOverrideConfigurationExpressionHolder;
import org.mule.modules.security.encryption.processors.DecryptMessageProcessor;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DecryptDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(DecryptDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)DecryptMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [decrypt] within the connector [encryption] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [decrypt] within the connector [encryption] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"decrypt");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        if (this.hasAttribute(element, "input-ref")) {
            if (element.getAttribute("input-ref").startsWith("#")) {
                builder.addPropertyValue("input", (Object)element.getAttribute("input-ref"));
            } else {
                builder.addPropertyValue("input", (Object)("#[registry:" + element.getAttribute("input-ref") + "]"));
            }
        }
        this.parseProperty(builder, element, "using", "using");
        if (!this.parseObjectRef(element, builder, "jce-encrypter", "jceEncrypter")) {
            BeanDefinitionBuilder jceEncrypterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)JCEEncrypterOverrideConfigurationExpressionHolder.class.getName());
            Element jceEncrypterChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"jce-encrypter");
            if (jceEncrypterChildElement != null) {
                this.parseProperty(jceEncrypterBuilder, jceEncrypterChildElement, "key", "key");
                this.parseProperty(jceEncrypterBuilder, jceEncrypterChildElement, "keyPassword", "keyPassword");
                this.parseProperty(jceEncrypterBuilder, jceEncrypterChildElement, "algorithm", "algorithm");
                this.parseProperty(jceEncrypterBuilder, jceEncrypterChildElement, "encryptionMode", "encryptionMode");
                builder.addPropertyValue("jceEncrypter", (Object)jceEncrypterBuilder.getBeanDefinition());
            }
        }
        if (!this.parseObjectRef(element, builder, "xml-encrypter", "xmlEncrypter")) {
            BeanDefinitionBuilder xmlEncrypterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)XmlEncrypterOverrideConfigurationExpressionHolder.class.getName());
            Element xmlEncrypterChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"xml-encrypter");
            if (xmlEncrypterChildElement != null) {
                this.parseProperty(xmlEncrypterBuilder, xmlEncrypterChildElement, "key", "key");
                this.parseProperty(xmlEncrypterBuilder, xmlEncrypterChildElement, "keyPassword", "keyPassword");
                this.parseProperty(xmlEncrypterBuilder, xmlEncrypterChildElement, "xpath", "xpath");
                this.parseProperty(xmlEncrypterBuilder, xmlEncrypterChildElement, "algorithm", "algorithm");
                builder.addPropertyValue("xmlEncrypter", (Object)xmlEncrypterBuilder.getBeanDefinition());
            }
        }
        if (!this.parseObjectRef(element, builder, "pgp-encrypter", "pgpEncrypter")) {
            BeanDefinitionBuilder pgpEncrypterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PGPEncrypterOverrideConfigurationExpressionHolder.class.getName());
            Element pgpEncrypterChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"pgp-encrypter");
            if (pgpEncrypterChildElement != null) {
                this.parseProperty(pgpEncrypterBuilder, pgpEncrypterChildElement, "principal", "principal");
                this.parseProperty(pgpEncrypterBuilder, pgpEncrypterChildElement, "encryptionAlgorithm", "encryptionAlgorithm");
                this.parseProperty(pgpEncrypterBuilder, pgpEncrypterChildElement, "outputMode", "outputMode");
                builder.addPropertyValue("pgpEncrypter", (Object)pgpEncrypterBuilder.getBeanDefinition());
            }
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

