/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.config;

import org.mule.config.MuleManifest;
import org.mule.modules.security.encryption.config.DecryptDefinitionParser;
import org.mule.modules.security.encryption.config.EncryptDefinitionParser;
import org.mule.modules.security.encryption.config.EncryptionModuleConfigDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class EncryptionNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(EncryptionNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [encryption] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [encryption] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new EncryptionModuleConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("encrypt", (BeanDefinitionParser)new EncryptDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("encrypt", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("decrypt", (BeanDefinitionParser)new DecryptDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("decrypt", "@Processor", ex);
        }
    }
}

