/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.encrypters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.util.encoders.Base64;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.transport.OutputHandler;
import org.mule.modules.security.encryption.encrypters.JCEEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.JCEEncrypterOverrideConfiguration;
import org.mule.security.encryption.MuleEncryptionException;
import org.mule.security.encryption.binary.Encrypter;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionAlgorithm;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionMode;

public class JCEEncrypterModule {
    private JCEEncrypterConfiguration defaultConfiguration;
    private JCEEncrypterOverrideConfiguration overrideConfiguration;

    public JCEEncrypterModule(JCEEncrypterConfiguration defaultConfiguration, JCEEncrypterOverrideConfiguration overrideConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
    }

    public Object encrypt(Object input) throws MuleEncryptionException {
        if (input instanceof byte[]) {
            return this.buildEncrypter(this.getKeyPasswordToUse(), this.getKeyToUse()).encrypt((byte[])input);
        }
        if (input instanceof InputStream) {
            return this.delayEncrypt((InputStream)input, this.getKeyToUse(), this.getKeyPasswordToUse());
        }
        if (input instanceof OutputHandler) {
            Object object;
            ByteArrayInputStream is = null;
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ((OutputHandler)input).write(RequestContext.getEvent(), (OutputStream)bytes);
                is = new ByteArrayInputStream(bytes.toByteArray());
                object = this.delayEncrypt(is, this.getKeyToUse(), this.getKeyPasswordToUse());
            }
            catch (IOException ex) {
                try {
                    throw new MuleEncryptionException("Could not encrypt the data. The input was unreadable.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return object;
        }
        if (input instanceof String) {
            return new String(Base64.encode((byte[])this.buildEncrypter(this.getKeyPasswordToUse(), this.getKeyToUse()).encrypt(((String)input).getBytes())));
        }
        throw new RuntimeException("Could not encrypt the input. The input has to be a byte array,Input Stream or String");
    }

    public Object decrypt(Object input) throws MuleEncryptionException {
        if (input instanceof byte[]) {
            return this.buildEncrypter(this.getKeyPasswordToUse(), this.getKeyToUse()).decrypt((byte[])input);
        }
        if (input instanceof InputStream) {
            return this.delayDecrypt((InputStream)input, this.getKeyToUse(), this.getKeyPasswordToUse());
        }
        if (input instanceof OutputHandler) {
            Object object;
            ByteArrayInputStream is = null;
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ((OutputHandler)input).write(RequestContext.getEvent(), (OutputStream)bytes);
                is = new ByteArrayInputStream(bytes.toByteArray());
                object = this.delayDecrypt(is, this.getKeyToUse(), this.getKeyPasswordToUse());
            }
            catch (IOException ex) {
                try {
                    throw new MuleEncryptionException("Could not decrypt the data. The input was unreadable.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return object;
        }
        if (input instanceof String) {
            return new String(this.buildEncrypter(this.getKeyPasswordToUse(), this.getKeyToUse()).decrypt(Base64.decode((String)((String)input))));
        }
        throw new RuntimeException("Could not decrypt the input. The input has to be a byte array,Input Stream or String");
    }

    private Object delayDecrypt(final InputStream input, final String key, final String keyPassword) {
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                try {
                    JCEEncrypterModule.this.buildEncrypter(keyPassword, key).decrypt(input, out);
                }
                catch (MuleEncryptionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private String getKeyPasswordToUse() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getKeyPassword() != null) {
            return this.overrideConfiguration.getKeyPassword();
        }
        return this.defaultConfiguration.getKeyPassword();
    }

    private String getKeyToUse() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getKey() != null) {
            return this.overrideConfiguration.getKey();
        }
        return this.defaultConfiguration.getKey();
    }

    private EncryptionMode encryptionMode() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getEncryptionMode() != null) {
            return this.overrideConfiguration.getEncryptionMode();
        }
        return this.defaultConfiguration.getEncryptionMode();
    }

    private String keystorePath() {
        return this.defaultConfiguration.getKeystorePath();
    }

    private boolean isUsePublicKeyToEncrypt() {
        return this.defaultConfiguration.isUsePublicKeyToEncrypt();
    }

    private boolean isUseRandomIV() {
        return this.defaultConfiguration.isUseRandomIV();
    }

    private String keystorePassword() {
        return this.defaultConfiguration.getKeystorePassword();
    }

    private EncryptionAlgorithm algorithm() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getAlgorithm() != null) {
            return this.overrideConfiguration.getAlgorithm();
        }
        return this.defaultConfiguration.getAlgorithm();
    }

    private Encrypter buildEncrypter(String keyPassword, String key) {
        EncryptionAlgorithm encryptionAlgorithm = this.algorithm();
        return encryptionAlgorithm.getBuilder().using(this.encryptionMode()).createWith(this.keystorePath(), this.keystorePassword()).usePublicKeyToEncrypt(this.isUsePublicKeyToEncrypt()).useRandomIV(this.isUseRandomIV()).forKey(key, keyPassword).build();
    }

    private Object delayEncrypt(final InputStream input, final String key, final String keyPassword) {
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                try {
                    JCEEncrypterModule.this.buildEncrypter(keyPassword, key).encrypt(input, out);
                }
                catch (MuleEncryptionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

