/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.encrypters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.transport.OutputHandler;
import org.mule.module.pgp.config.PGPOutputMode;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterOverrideConfiguration;
import org.mule.security.encryption.MuleEncryptionException;
import org.mule.security.encryption.binary.pgp.PGPEncrypter;
import org.mule.util.StringUtils;

public class PGPEncrypterModule {
    private PGPEncrypterConfiguration defaultConfiguration;
    private PGPEncrypterOverrideConfiguration overrideConfiguration;
    private String streamName = "stream";

    public PGPEncrypterModule(PGPEncrypterConfiguration defaultConfiguration, PGPEncrypterOverrideConfiguration overrideConfiguration, String streamName) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
        this.streamName = streamName;
    }

    public PGPEncrypterModule(PGPEncrypterConfiguration defaultConfiguration, PGPEncrypterOverrideConfiguration overrideConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
    }

    public Object encrypt(Object input) throws MuleEncryptionException {
        if (StringUtils.isEmpty((String)this.publicKeyFile())) {
            throw new MuleEncryptionException("Could not encrypt the data because 'publicKeyRingFileName' was not defined in configuration");
        }
        if (input instanceof byte[]) {
            return new PGPEncrypter(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.streamName, this.principal(), this.algorithm(), this.mode()).encrypt((byte[])input);
        }
        if (input instanceof InputStream) {
            return this.delayEncrypt((InputStream)input);
        }
        if (input instanceof OutputHandler) {
            Object object;
            ByteArrayInputStream is = null;
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ((OutputHandler)input).write(RequestContext.getEvent(), (OutputStream)bytes);
                is = new ByteArrayInputStream(bytes.toByteArray());
                object = this.delayEncrypt(is);
            }
            catch (IOException ex) {
                try {
                    throw new MuleEncryptionException("Could not encrypt the data. The input was unreadable.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return object;
        }
        if (input instanceof String) {
            return new String(new PGPEncrypter(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.streamName, this.principal(), this.algorithm(), this.mode()).encrypt(((String)input).getBytes()));
        }
        throw new RuntimeException("Could not encrypt the input. The input has to be a byte array, Input Stream or String");
    }

    public Object decrypt(Object input) throws MuleEncryptionException {
        if (StringUtils.isEmpty((String)this.publicKeyFile()) || StringUtils.isEmpty((String)this.privateKeyFile()) || StringUtils.isEmpty((String)this.passphrase())) {
            throw new MuleEncryptionException("Could not decrypt the data because 'publicKeyRingFileName', 'secretKeyRingFileName' or 'secretPassphrase' were not defined in configuration");
        }
        if (input instanceof byte[]) {
            return new PGPEncrypter(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.streamName, this.principal(), this.algorithm(), this.mode()).decrypt((byte[])input);
        }
        if (input instanceof OutputHandler) {
            Object object;
            ByteArrayInputStream is = null;
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ((OutputHandler)input).write(RequestContext.getEvent(), (OutputStream)bytes);
                is = new ByteArrayInputStream(bytes.toByteArray());
                object = this.delayDecrypt(is);
            }
            catch (IOException ex) {
                try {
                    throw new MuleEncryptionException("Could not decrypt the data. The input was unreadable.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return object;
        }
        if (input instanceof InputStream) {
            return this.delayDecrypt((InputStream)input);
        }
        if (input instanceof String) {
            return new String(new PGPEncrypter(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.streamName, this.principal(), this.algorithm(), this.mode()).decrypt(((String)input).getBytes()));
        }
        throw new RuntimeException("Could not decrypt the input. The input has to be a byte array,Input Stream or String");
    }

    private Object delayEncrypt(final InputStream input) {
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                try {
                    new PGPEncrypter(PGPEncrypterModule.this.publicKeyFile(), PGPEncrypterModule.this.privateKeyFile(), PGPEncrypterModule.this.aliasId(), PGPEncrypterModule.this.passphrase(), PGPEncrypterModule.this.streamName, PGPEncrypterModule.this.principal(), PGPEncrypterModule.this.algorithm(), PGPEncrypterModule.this.mode()).encrypt(input, out);
                }
                catch (MuleEncryptionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Object delayDecrypt(final InputStream input) {
        return new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                try {
                    new PGPEncrypter(PGPEncrypterModule.this.publicKeyFile(), PGPEncrypterModule.this.privateKeyFile(), PGPEncrypterModule.this.aliasId(), PGPEncrypterModule.this.passphrase(), PGPEncrypterModule.this.streamName, PGPEncrypterModule.this.principal(), PGPEncrypterModule.this.algorithm(), PGPEncrypterModule.this.mode()).decrypt(input, out);
                }
                catch (MuleEncryptionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private String passphrase() {
        return this.defaultConfiguration.getSecretPassphrase();
    }

    private String aliasId() {
        return this.defaultConfiguration.getSecretAliasId();
    }

    private String privateKeyFile() {
        return this.defaultConfiguration.getSecretKeyRingFileName();
    }

    private String principal() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getPrincipal() != null) {
            return this.overrideConfiguration.getPrincipal();
        }
        return this.defaultConfiguration.getPrincipal();
    }

    private String publicKeyFile() {
        return this.defaultConfiguration.getPublicKeyRingFileName();
    }

    private String algorithm() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getEncryptionAlgorithm() != null) {
            return this.overrideConfiguration.getEncryptionAlgorithm();
        }
        return this.defaultConfiguration.getEncryptionAlgorithm();
    }

    private PGPOutputMode mode() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getOutputMode() != null) {
            return this.overrideConfiguration.getOutputMode();
        }
        return this.defaultConfiguration.getOutputMode();
    }
}

