/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.config;

import org.mule.config.MuleManifest;
import org.mule.module.signature.adapters.SignatureModuleLicenseChecker;
import org.mule.module.signature.signers.JCESignerConfiguration;
import org.mule.module.signature.signers.PGPSignerConfiguration;
import org.mule.module.signature.signers.XmlSignerConfiguration;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SignatureModuleConfigDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(SignatureModuleConfigDefinitionParser.class);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, SignatureModuleLicenseChecker.class);
        this.setDestroyMethodIfNeeded(builder, SignatureModuleLicenseChecker.class);
        this.parseProperty(builder, element, "enableLanguage", "enableLanguage");
        if (!this.parseNoExprObjectRef(element, builder, "jce-signer-config", "jceSignerConfig")) {
            BeanDefinitionBuilder jceSignerConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)JCESignerConfiguration.class.getName());
            Element jceSignerConfigChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"jce-signer-config");
            if (jceSignerConfigChildElement != null) {
                this.parseProperty(jceSignerConfigBuilder, jceSignerConfigChildElement, "algorithm", "algorithm");
                this.parseProperty(jceSignerConfigBuilder, jceSignerConfigChildElement, "key", "key");
                this.parseProperty(jceSignerConfigBuilder, jceSignerConfigChildElement, "keystorePath", "keystorePath");
                this.parseProperty(jceSignerConfigBuilder, jceSignerConfigChildElement, "keystorePassword", "keystorePassword");
                this.parseProperty(jceSignerConfigBuilder, jceSignerConfigChildElement, "keyPassword", "keyPassword");
                builder.addPropertyValue("jceSignerConfig", (Object)jceSignerConfigBuilder.getBeanDefinition());
            }
        }
        if (!this.parseNoExprObjectRef(element, builder, "xml-signer-config", "xmlSignerConfig")) {
            BeanDefinitionBuilder xmlSignerConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)XmlSignerConfiguration.class.getName());
            Element xmlSignerConfigChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"xml-signer-config");
            if (xmlSignerConfigChildElement != null) {
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "digestMethodAlgorithm", "digestMethodAlgorithm");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "canonicalizationAlgorithm", "canonicalizationAlgorithm");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "signatureMethodAlgorithm", "signatureMethodAlgorithm");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "signatureType", "signatureType");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "referenceUri", "referenceUri");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "verificationExpression", "verificationExpression");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "key", "key");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "keystorePath", "keystorePath");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "keystorePassword", "keystorePassword");
                this.parseProperty(xmlSignerConfigBuilder, xmlSignerConfigChildElement, "keyPassword", "keyPassword");
                builder.addPropertyValue("xmlSignerConfig", (Object)xmlSignerConfigBuilder.getBeanDefinition());
            }
        }
        if (!this.parseNoExprObjectRef(element, builder, "pgp-signer-config", "pgpSignerConfig")) {
            BeanDefinitionBuilder pgpSignerConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PGPSignerConfiguration.class.getName());
            Element pgpSignerConfigChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"pgp-signer-config");
            if (pgpSignerConfigChildElement != null) {
                this.parseProperty(pgpSignerConfigBuilder, pgpSignerConfigChildElement, "algorithm", "algorithm");
                this.parseProperty(pgpSignerConfigBuilder, pgpSignerConfigChildElement, "publicKeyRingFileName", "publicKeyRingFileName");
                this.parseProperty(pgpSignerConfigBuilder, pgpSignerConfigChildElement, "secretKeyRingFileName", "secretKeyRingFileName");
                this.parseProperty(pgpSignerConfigBuilder, pgpSignerConfigChildElement, "secretAliasId", "secretAliasId");
                this.parseProperty(pgpSignerConfigBuilder, pgpSignerConfigChildElement, "secretPassphrase", "secretPassphrase");
                this.parseProperty(pgpSignerConfigBuilder, pgpSignerConfigChildElement, "outputMode", "outputMode");
                builder.addPropertyValue("pgpSignerConfig", (Object)pgpSignerConfigBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "defaultSigner", "defaultSigner");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        return definition;
    }

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)SignatureModuleLicenseChecker.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the configuration [config] within the connector [signature] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the configuration [config] within the connector [signature] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }
}

