/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.config;

import org.mule.config.MuleManifest;
import org.mule.module.signature.processors.VerifySignatureMessageProcessor;
import org.mule.module.signature.signers.holders.JCESignerOverrideConfigurationExpressionHolder;
import org.mule.module.signature.signers.holders.PGPSignerOverrideConfigurationExpressionHolder;
import org.mule.module.signature.signers.holders.XmlSignerOverrideConfigurationExpressionHolder;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class VerifySignatureDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(VerifySignatureDefinitionParser.class);

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)VerifySignatureMessageProcessor.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the @Processor [verify-signature] within the connector [signature] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the @Processor [verify-signature] within the connector [signature] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.addConstructorArgValue((Object)"verifySignature");
        builder.setScope("prototype");
        this.parseConfigRef(element, builder);
        this.parseProperty(builder, element, "input", "input");
        this.parseProperty(builder, element, "using", "using");
        if (!this.parseObjectRef(element, builder, "jce-signer", "jceSigner")) {
            BeanDefinitionBuilder jceSignerBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)JCESignerOverrideConfigurationExpressionHolder.class.getName());
            Element jceSignerChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"jce-signer");
            if (jceSignerChildElement != null) {
                this.parseProperty(jceSignerBuilder, jceSignerChildElement, "algorithm", "algorithm");
                this.parseProperty(jceSignerBuilder, jceSignerChildElement, "key", "key");
                this.parseProperty(jceSignerBuilder, jceSignerChildElement, "keyPassword", "keyPassword");
                builder.addPropertyValue("jceSigner", (Object)jceSignerBuilder.getBeanDefinition());
            }
        }
        if (!this.parseObjectRef(element, builder, "xml-signer", "xmlSigner")) {
            BeanDefinitionBuilder xmlSignerBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)XmlSignerOverrideConfigurationExpressionHolder.class.getName());
            Element xmlSignerChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"xml-signer");
            if (xmlSignerChildElement != null) {
                this.parseProperty(xmlSignerBuilder, xmlSignerChildElement, "digestMethodAlgorithm", "digestMethodAlgorithm");
                this.parseProperty(xmlSignerBuilder, xmlSignerChildElement, "canonicalizationAlgorithm", "canonicalizationAlgorithm");
                this.parseProperty(xmlSignerBuilder, xmlSignerChildElement, "signatureMethodAlgorithm", "signatureMethodAlgorithm");
                this.parseProperty(xmlSignerBuilder, xmlSignerChildElement, "signatureType", "signatureType");
                this.parseProperty(xmlSignerBuilder, xmlSignerChildElement, "referenceUri", "referenceUri");
                this.parseProperty(xmlSignerBuilder, xmlSignerChildElement, "key", "key");
                this.parseProperty(xmlSignerBuilder, xmlSignerChildElement, "keyPassword", "keyPassword");
                this.parseProperty(xmlSignerBuilder, xmlSignerChildElement, "verificationExpression", "verificationExpression");
                builder.addPropertyValue("xmlSigner", (Object)xmlSignerBuilder.getBeanDefinition());
            }
        }
        if (!this.parseObjectRef(element, builder, "pgp-signer", "pgpSigner")) {
            BeanDefinitionBuilder pgpSignerBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PGPSignerOverrideConfigurationExpressionHolder.class.getName());
            Element pgpSignerChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"pgp-signer");
            if (pgpSignerChildElement != null) {
                this.parseProperty(pgpSignerBuilder, pgpSignerChildElement, "algorithm", "algorithm");
                this.parseProperty(pgpSignerBuilder, pgpSignerChildElement, "outputMode", "outputMode");
                builder.addPropertyValue("pgpSigner", (Object)pgpSignerBuilder.getBeanDefinition());
            }
        }
        this.parseProperty(builder, element, "expectedSignature", "expectedSignature");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        this.attachProcessorDefinition(parserContext, (BeanDefinition)definition);
        return definition;
    }
}

