/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.language;

import java.io.InputStream;
import org.mule.module.signature.signers.JCESignerConfiguration;
import org.mule.module.signature.signers.JCESignerModule;
import org.mule.module.signature.signers.JCESignerOverrideConfiguration;

public class JCESignerWrapper {
    private JCESignerConfiguration binaryConfig;

    public JCESignerWrapper(JCESignerConfiguration binaryConfig) {
        this.binaryConfig = binaryConfig;
    }

    public String sign(Object input, String key, String keyPassword) {
        this.checkInput(input);
        JCESignerOverrideConfiguration overrideConfiguration = new JCESignerOverrideConfiguration();
        overrideConfiguration.setKey(key);
        overrideConfiguration.setKeyPassword(keyPassword);
        return (String)new JCESignerModule(this.binaryConfig, overrideConfiguration, null).sign(input);
    }

    public String sign(Object input, String key) {
        this.checkInput(input);
        JCESignerOverrideConfiguration overrideConfiguration = new JCESignerOverrideConfiguration();
        overrideConfiguration.setKey(key);
        return (String)new JCESignerModule(this.binaryConfig, overrideConfiguration, null).sign(input);
    }

    public String sign(Object input) {
        this.checkInput(input);
        return (String)new JCESignerModule(this.binaryConfig, null, null).sign(input);
    }

    public boolean verifySignature(Object input, String key, String keyPassword, String expectedSignature) {
        JCESignerOverrideConfiguration overrideConfiguration = new JCESignerOverrideConfiguration();
        overrideConfiguration.setKey(key);
        overrideConfiguration.setKeyPassword(keyPassword);
        return new JCESignerModule(this.binaryConfig, overrideConfiguration, null).doVerifySignature(input, expectedSignature);
    }

    public boolean verifySignature(Object input, String key, String expectedSignature) {
        JCESignerOverrideConfiguration overrideConfiguration = new JCESignerOverrideConfiguration();
        overrideConfiguration.setKey(key);
        return new JCESignerModule(this.binaryConfig, overrideConfiguration, null).doVerifySignature(input, expectedSignature);
    }

    public boolean verifySignature(Object input, String expectedSignature) {
        return new JCESignerModule(this.binaryConfig, null, null).doVerifySignature(input, expectedSignature);
    }

    private void checkInput(Object input) {
        if (input instanceof InputStream) {
            throw new RuntimeException("Signature Streamming is not allowed in MEL");
        }
    }
}

