/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.language;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.encoders.Base64;
import org.mule.module.pgp.config.PGPOutputMode;
import org.mule.module.signature.signers.PGPSignerConfiguration;
import org.mule.module.signature.signers.PGPSignerModule;

public class PGPSignerWrapper {
    private PGPSignerConfiguration pgpConfig;

    public PGPSignerWrapper(PGPSignerConfiguration pgpConfig) {
        this.pgpConfig = pgpConfig;
    }

    public Object loadBinarySignature(Object expectedSignature) throws IOException {
        if (expectedSignature instanceof byte[]) {
            return Base64.toBase64String((byte[])((byte[])expectedSignature));
        }
        if (expectedSignature instanceof InputStream) {
            return Base64.toBase64String((byte[])IOUtils.toByteArray((InputStream)((InputStream)expectedSignature)));
        }
        return expectedSignature;
    }

    public Object sign(Object input, String outputMode) throws PGPException {
        this.pgpConfig.setOutputMode(PGPOutputMode.valueOf((String)outputMode));
        return new PGPSignerModule(this.pgpConfig, null).sign(input);
    }

    public boolean verifySignature(Object message, Object detachedSignature) throws Exception {
        return new PGPSignerModule(this.pgpConfig, null).validateSignature(message, detachedSignature);
    }
}

