/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.encryption.binary.jce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import org.mule.security.encryption.MuleEncryptionException;
import org.mule.security.encryption.NotSupportedInFipsModeException;
import org.mule.security.encryption.binary.Encrypter;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionAlgorithm;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionMode;
import org.mule.security.encryption.binary.jce.algorithms.EncryptionPadding;
import org.mule.security.encryption.binary.jce.iv.DecrypterRandomIVReader;
import org.mule.security.encryption.binary.jce.iv.DecrypterRandomIVReaderFactory;
import org.mule.security.utils.AESFactory;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;
import org.mule.util.IOUtils;

public class JCEEncrypter
implements Encrypter {
    protected EncryptionAlgorithm encryptionAlgorithm;
    protected EncryptionMode encryptionMode;
    protected EncryptionPadding encryptionPadding;
    private EncryptionKeyFactory keyFactory;
    private boolean useRandomIV;
    private static final String INSTALL_JCE_MESSAGE = "You need to install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files";
    private static final String FIPS_MODE_MESSAGE = "You're running in FIPS mode  so please verify that the algorithm is compliant with FIPS.";
    private static final String SHORT_KEY_MESSAGE = "You need to increment your key size  The minimum allowed key size is: %d  But your key size is: %d";
    private static final String LONG_KEY_MESSAGE = "Your key size exceeds the maximum allowed key size in your JVM.  The maximum allowed key size is: %d But your key size is: %d.";

    public JCEEncrypter(EncryptionAlgorithm encryptionAlgorithm, EncryptionMode encryptionMode, EncryptionPadding encryptionPadding, EncryptionKeyFactory keyFactory) {
        this(encryptionAlgorithm, encryptionMode, encryptionPadding, keyFactory, false);
    }

    public JCEEncrypter(EncryptionAlgorithm encryptionAlgorithm, EncryptionMode encryptionMode, EncryptionPadding encryptionPadding, EncryptionKeyFactory keyFactory, boolean useRandomIV) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptionMode = encryptionMode;
        this.encryptionPadding = encryptionPadding;
        this.keyFactory = keyFactory;
        this.useRandomIV = useRandomIV;
    }

    @Override
    public byte[] encrypt(byte[] data) throws MuleEncryptionException {
        try {
            Cipher cipher = AESFactory.getCipher(this.createXForm());
            Key cipherKey = this.keyFactory.buildEncryptionKey();
            this.initEncrypterCipher(cipher, cipherKey, this.keyFactory.getPlainKey());
            byte[] result = cipher.doFinal(data);
            byte[] ivInByteArray = cipher.getIV();
            if (this.useRandomIV && ivInByteArray != null) {
                byte[] byteArrayToConcatEncryptedDataAndIV = new byte[ivInByteArray.length + result.length];
                System.arraycopy(ivInByteArray, 0, byteArrayToConcatEncryptedDataAndIV, 0, ivInByteArray.length);
                System.arraycopy(result, 0, byteArrayToConcatEncryptedDataAndIV, ivInByteArray.length, result.length);
                return byteArrayToConcatEncryptedDataAndIV;
            }
            return result;
        }
        catch (Exception e) {
            throw this.buildEncryptionException(e, this.keyFactory.getPlainKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(InputStream in, OutputStream out) throws MuleEncryptionException {
        try {
            int numRead;
            Cipher cipher = AESFactory.getCipher(this.createXForm());
            Key cipherKey = this.keyFactory.buildEncryptionKey();
            this.initEncrypterCipher(cipher, cipherKey, this.keyFactory.getPlainKey());
            byte[] ivInByteArray = cipher.getIV();
            if (this.useRandomIV && ivInByteArray != null) {
                out.write(ivInByteArray);
            }
            byte[] buf = new byte[1024];
            out = new CipherOutputStream(out, cipher);
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
        }
        catch (Exception e) {
            this.buildEncryptionException(e, this.keyFactory.getPlainKey());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) throws MuleEncryptionException {
        try {
            Cipher cipher = AESFactory.getCipher(this.createXForm());
            Key cipherKey = this.keyFactory.buildDecryptionKey();
            DecrypterRandomIVReader randomIVReader = DecrypterRandomIVReaderFactory.create(this.ivSize(cipher), data);
            this.initDecrypterCipher(cipher, cipherKey, this.keyFactory.getPlainKey(), randomIVReader);
            byte[] ivInByteArray = cipher.getIV();
            if (this.useRandomIV && ivInByteArray != null) {
                data = Arrays.copyOfRange(data, ivInByteArray.length, data.length);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw this.buildEncryptionException(e, this.keyFactory.getPlainKey());
        }
    }

    @Override
    public void decrypt(InputStream in, OutputStream out) throws MuleEncryptionException {
        try {
            int numRead;
            Cipher cipher = AESFactory.getCipher(this.createXForm());
            Key cipherKey = this.keyFactory.buildDecryptionKey();
            DecrypterRandomIVReader randomIVReader = DecrypterRandomIVReaderFactory.create(this.ivSize(cipher), in);
            this.initDecrypterCipher(cipher, cipherKey, this.keyFactory.getPlainKey(), randomIVReader);
            in = new CipherInputStream(in, cipher);
            byte[] buf = new byte[1024];
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
        }
        catch (Exception e) {
            throw this.buildEncryptionException(e, this.keyFactory.getPlainKey());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private String createXForm() {
        return this.encryptionAlgorithm.name() + "/" + this.encryptionMode.name() + "/" + this.encryptionPadding.name();
    }

    private void initEncrypterCipher(Cipher cipher, Key cipherKey, String key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.encryptionMode.equals((Object)EncryptionMode.ECB)) {
            cipher.init(1, cipherKey);
        } else {
            byte[] ivInByteArray;
            SecureRandom secureRandom = new SecureRandom();
            if (this.useRandomIV) {
                ivInByteArray = new byte[this.ivSize(cipher)];
                secureRandom.nextBytes(ivInByteArray);
            } else {
                ivInByteArray = Arrays.copyOfRange(key.getBytes(), 0, this.ivSize(cipher));
            }
            cipher.init(1, cipherKey, new IvParameterSpec(ivInByteArray), secureRandom);
        }
    }

    private void initDecrypterCipher(Cipher cipher, Key cipherKey, String key, DecrypterRandomIVReader decrypterRandomIVReader) throws InvalidKeyException, InvalidAlgorithmParameterException, IOException {
        if (this.encryptionMode.equals((Object)EncryptionMode.ECB)) {
            cipher.init(2, cipherKey);
        } else {
            SecureRandom secureRandom = new SecureRandom();
            byte[] ivInByteArray = this.useRandomIV ? decrypterRandomIVReader.read() : Arrays.copyOfRange(key.getBytes(), 0, this.ivSize(cipher));
            cipher.init(2, cipherKey, new IvParameterSpec(ivInByteArray), secureRandom);
        }
    }

    private int ivSize(Cipher cipher) {
        if (this.useRandomIV) {
            return cipher.getBlockSize();
        }
        return this.encryptionAlgorithm.getIvSize() == 0 ? 8 : this.encryptionAlgorithm.getIvSize();
    }

    private MuleEncryptionException buildEncryptionException(Exception e, String key) {
        if (e instanceof InvalidAlgorithmParameterException) {
            return this.handleInvalidAlgorithmParameterException((InvalidAlgorithmParameterException)e);
        }
        if (e instanceof InvalidKeyException) {
            return this.handleInvalidKeyException((InvalidKeyException)e, key);
        }
        if (e instanceof NoSuchAlgorithmException) {
            return this.wrapNoSuchAlgorithmException((NoSuchAlgorithmException)e);
        }
        return new MuleEncryptionException("Could not encrypt the data.", e);
    }

    private MuleEncryptionException handleInvalidAlgorithmParameterException(InvalidAlgorithmParameterException e) {
        String message = String.format("Wrong configuration for algorithm: %s.", this.encryptionAlgorithm.name());
        if (!AESFactory.isJCEInstalled()) {
            message = message + INSTALL_JCE_MESSAGE;
        }
        return new MuleEncryptionException(message, e);
    }

    private MuleEncryptionException wrapNoSuchAlgorithmException(NoSuchAlgorithmException e) {
        String message = String.format("Invalid algorithm: %s.", this.encryptionAlgorithm.name());
        if (!AESFactory.isJCEInstalled()) {
            message = message + INSTALL_JCE_MESSAGE;
            return new MuleEncryptionException(message, e);
        }
        if (AESFactory.isFipsEnabled()) {
            return new MuleEncryptionException(message, new NotSupportedInFipsModeException(FIPS_MODE_MESSAGE, e));
        }
        return new MuleEncryptionException(message, e);
    }

    private MuleEncryptionException handleInvalidKeyException(InvalidKeyException e, String key) {
        String message = String.format("Invalid key.", key);
        if (key.getBytes().length > this.encryptionAlgorithm.getMaxKeySize()) {
            message = message + String.format(LONG_KEY_MESSAGE, this.encryptionAlgorithm.getMaxKeySize(), key.getBytes().length);
            if (!AESFactory.isJCEInstalled()) {
                message = message + INSTALL_JCE_MESSAGE;
            }
        } else if (key.getBytes().length < this.encryptionAlgorithm.getMinKeySize()) {
            message = message + String.format(SHORT_KEY_MESSAGE, this.encryptionAlgorithm.getMinKeySize(), key.getBytes().length);
        }
        return new MuleEncryptionException(message, e);
    }
}

