/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.encryption.xml;

import com.sun.org.apache.xpath.internal.NodeSet;
import java.security.Key;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.mule.security.encryption.xml.XmlEncryptionAlgorithm;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlEncrypter {
    private XmlEncryptionAlgorithm algorithm;
    private EncryptionKeyFactory factory;
    private XPath xpath;

    public XmlEncrypter(XmlEncryptionAlgorithm algorithm, EncryptionKeyFactory factory) {
        Init.init();
        this.algorithm = algorithm;
        this.factory = factory;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        this.xpath = xPathfactory.newXPath();
    }

    public Document encrypt(Document document, String element) throws Exception {
        Key keyEncryptKey = this.factory.buildEncryptionKey();
        SecretKey symmetricKey = XmlEncrypter.generateSymmetricKey(this.algorithm);
        XMLCipher keyCipher = XMLCipher.getInstance((String)this.algorithm.getWrap());
        keyCipher.init(3, keyEncryptKey);
        EncryptedKey encryptedKey = keyCipher.encryptKey(document, (Key)symmetricKey);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)this.algorithm.getValue());
        xmlCipher.init(1, (Key)symmetricKey);
        EncryptedData encryptedDataElement = xmlCipher.getEncryptedData();
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.add(encryptedKey);
        encryptedDataElement.setKeyInfo(keyInfo);
        NodeList elementsToEncrypt = this.getElement(element, document);
        for (int i = 0; i < elementsToEncrypt.getLength(); ++i) {
            Element item = (Element)elementsToEncrypt.item(i);
            xmlCipher.doFinal(document, item, true);
        }
        return document;
    }

    private NodeList getElement(String xpathExpr, Document document) {
        try {
            if (xpathExpr != null) {
                XPathExpression expr = this.xpath.compile(xpathExpr);
                return (NodeList)expr.evaluate(document, XPathConstants.NODESET);
            }
            return new NodeSet(document.getDocumentElement());
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Invalid xpath: " + xpathExpr);
        }
    }

    public Document decrypt(Document document) throws Exception {
        String namespaceURI = "http://www.w3.org/2001/04/xmlenc#";
        String localName = "EncryptedData";
        Key keyEncryptKey = this.factory.buildDecryptionKey();
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, null);
        xmlCipher.setKEK(keyEncryptKey);
        NodeList elementsToDecrypt = document.getElementsByTagNameNS(namespaceURI, localName);
        int numberOfElements = elementsToDecrypt.getLength();
        for (int i = 0; i < numberOfElements; ++i) {
            Element item = (Element)elementsToDecrypt.item(0);
            xmlCipher.doFinal(document, item);
        }
        return document;
    }

    public static SecretKey generateSymmetricKey(XmlEncryptionAlgorithm algorithm) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm.getAlgorithm());
        keyGenerator.init(algorithm.getSize());
        return keyGenerator.generateKey();
    }
}

