/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.data;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.mule.security.encryption.NotSupportedInFipsModeException;
import org.mule.security.signature.data.Signer;
import org.mule.security.utils.AESFactory;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;
import org.mule.util.IOUtils;

public class HMACSigner
implements Signer {
    private String signatureAlgorithm;
    private EncryptionKeyFactory factory;

    public HMACSigner(String signatureAlgorithm, EncryptionKeyFactory factory) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.factory = factory;
    }

    @Override
    public String sign(byte[] data) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            Mac mac = this.getMac();
            byte[] hmacData = mac.doFinal(data);
            new Base64Encoder().encode(hmacData, 0, hmacData.length, (OutputStream)bout);
            String string = bout.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not sign your data", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bout);
        }
    }

    private Mac getMac() throws InvalidKeyException {
        Key secretKey = this.factory.buildEncryptionKey();
        try {
            Mac mac = Mac.getInstance(this.signatureAlgorithm);
            mac.init(secretKey);
            return mac;
        }
        catch (NoSuchAlgorithmException e) {
            throw this.wrap(e);
        }
    }

    private RuntimeException wrap(NoSuchAlgorithmException e) {
        if (AESFactory.isFipsEnabled()) {
            return new RuntimeException("Could not sign data", new NotSupportedInFipsModeException(String.format("Could not find HMAC signature algorithm '%s'. You're running in FIPS mode  so please verify that algorithm is compliant with FIPS.", this.signatureAlgorithm), e));
        }
        return new RuntimeException(String.format("Could not find HMAC signature algorithm '%s'.", this.signatureAlgorithm, e));
    }

    @Override
    public String sign(InputStream stream) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            Mac mac = this.getMac();
            byte[] buffer = new byte[1024];
            int read = -1;
            while (stream.available() > 0) {
                read = stream.read(buffer, 0, buffer.length);
                mac.update(buffer, 0, read);
            }
            byte[] hmacData = mac.doFinal();
            new Base64Encoder().encode(hmacData, 0, hmacData.length, (OutputStream)bout);
            String string = bout.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not sign your data", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)bout);
        }
    }

    @Override
    public boolean validateSignature(byte[] data, String expectedSignature) {
        String signature = this.sign(data);
        return signature.equals(expectedSignature);
    }

    @Override
    public boolean validateSignature(InputStream stream, String expectedSignature) {
        String signature = this.sign(stream);
        return signature.equals(expectedSignature);
    }
}

