/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.keyinfo;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.mule.security.encryption.NotSupportedInFipsModeException;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.algorithms.CanonicalizationAlgorithm;
import org.mule.security.signature.xml.algorithms.SignatureMethodAlgorithm;
import org.mule.security.signature.xml.keyinfo.KeyInfoProvider;
import org.mule.security.utils.AESFactory;

public class SecretKeyInfoProvider
implements KeyInfoProvider {
    private String secretKey;
    private String secretKeyAlgorithm;
    private CanonicalizationAlgorithm canonicalizationAlgorithm;

    public SecretKeyInfoProvider(String secretKey, String secretKeyAlgorithm, CanonicalizationAlgorithm canonicalizationAlgorithm) {
        this.secretKey = secretKey;
        this.secretKeyAlgorithm = secretKeyAlgorithm;
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
    }

    @Override
    public KeyInfo getKeyInfo() {
        return null;
    }

    @Override
    public Key getSecretKey() {
        return new SecretKeySpec(this.secretKey.getBytes(), this.secretKeyAlgorithm);
    }

    @Override
    public SignedInfo getSignedInfo(Reference ref) {
        String algorithm = SignatureMethodAlgorithm.HMAC_SHA1.getAlgorithm();
        try {
            return Signer.fac.newSignedInfo(Signer.fac.newCanonicalizationMethod(this.canonicalizationAlgorithm.getAlgorithm(), (C14NMethodParameterSpec)null), Signer.fac.newSignatureMethod(algorithm, null), Collections.singletonList(ref));
        }
        catch (NoSuchAlgorithmException e) {
            throw this.wrap(e, algorithm);
        }
        catch (Exception e) {
            throw new RuntimeException("Signed Info could not be created", e);
        }
    }

    private RuntimeException wrap(Exception exception, String algorithm) {
        if (AESFactory.isFipsEnabled()) {
            return new RuntimeException(new NotSupportedInFipsModeException(String.format("Could not find algorithm %s. Since you're running in FIPS mode, please make sure that the algorithm is FIPS compliant", algorithm), exception));
        }
        return new RuntimeException(String.format("Could not find algorithm %s", algorithm), exception);
    }
}

