/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.reference;

import java.util.List;
import javax.xml.crypto.dsig.Reference;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.algorithms.DigestMethodAlgorithm;
import org.mule.security.signature.xml.reference.SignatureContextProvider;
import org.mule.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DetachedSignatureContextProvider
implements SignatureContextProvider {
    private DigestMethodAlgorithm digestMethodAlgorithm;
    private String referenceUri;
    private Document document;

    public DetachedSignatureContextProvider(DigestMethodAlgorithm digestMethodAlgorithm, Document document, String referenceUri) {
        this.digestMethodAlgorithm = digestMethodAlgorithm;
        this.document = document;
        this.referenceUri = referenceUri;
    }

    @Override
    public Reference getReference() {
        try {
            this.setElementId(this.document.getDocumentElement(), this.referenceUri);
            return Signer.fac.newReference(this.referenceUri, Signer.fac.newDigestMethod(this.digestMethodAlgorithm.getAlgorithm(), null));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not getReference Detached Reference", e);
        }
    }

    @Override
    public List<Object> getReferencedObjects() {
        return null;
    }

    @Override
    public Node getSignatureParentNode() {
        return this.document.getDocumentElement();
    }

    private void setElementId(Element documentElement, String referenceUri) throws XPathExpressionException {
        if (this.isInternalURIReference(referenceUri)) {
            String id = referenceUri.substring(1);
            NodeList nodeList = (NodeList)XMLUtils.evaluateXpathExpression(XMLUtils.getIdXPathExpression(id), documentElement, XPathConstants.NODESET);
            if (nodeList.getLength() == 0) {
                throw new IllegalStateException(DetachedSignatureContextProvider.getXmlSourceIdNotFoundMessage(id));
            }
            if (nodeList.getLength() > 1) {
                throw new IllegalStateException(DetachedSignatureContextProvider.getXmlSourceDuplicateIdErrorMessage(id));
            }
            Element idElement = (Element)nodeList.item(0);
            idElement.setIdAttribute("id", true);
        }
    }

    public static String getXmlSourceDuplicateIdErrorMessage(String id) {
        return String.format("In the xml source, there are more than one element with the id '%s'", id);
    }

    public static String getXmlSourceIdNotFoundMessage(String id) {
        return String.format("The XML source doesn't contain the id '%s", id);
    }

    private boolean isInternalURIReference(String referenceUri) {
        return referenceUri != null && referenceUri.length() > 1 && referenceUri.startsWith("#");
    }
}

