/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.validator;

import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.xpath.XPathExpressionException;
import org.mule.module.xml.xpath.XPathReturnType;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.validator.SignatureValidator;
import org.mule.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DefaultSignatureValidator
implements SignatureValidator {
    public static final String NOT_FOUND_ELEMENT_WITH_GIVEN_VALIDATION_EXPRESSION = "No element was found with the given validationExpression. If your expression is right, this could be a (failed) attempt at xml signature wrapping attack.";
    public static final String MORE_THAN_ONE_ELEMENT_FOUND_WITH_GIVEN_VALIDATION_EXPRESSION = "More than one element were found with the given validationExpression but only one is allowed";
    public static final String MORE_THAN_ONE_SIGNATURE_FOUND = "More than one signature was found in the xml source.";
    private KeySelector keySelector;
    private String validationExpression;

    public DefaultSignatureValidator(KeySelector keySelector, String validationExpression) {
        this.keySelector = keySelector;
        this.validationExpression = validationExpression;
    }

    @Override
    public boolean validate(Document doc) throws Exception {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new RuntimeException("Cannot find Signature element");
        }
        if (nl.getLength() > 1) {
            throw new IllegalStateException(MORE_THAN_ONE_SIGNATURE_FOUND);
        }
        this.setValidIdAttribute(doc.getDocumentElement());
        DOMValidateContext valContext = new DOMValidateContext(this.keySelector, nl.item(0));
        XMLSignature signature = Signer.fac.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }

    private void setValidIdAttribute(Element docElement) throws XPathExpressionException {
        if (this.validationExpression != null) {
            if (this.validationExpression.startsWith("//")) {
                throw new IllegalStateException(DefaultSignatureValidator.getNotAbsoluteXpathExpressionErrorMessage(this.validationExpression));
            }
            NodeList nodeList = (NodeList)XMLUtils.evaluateXpathExpressionWithNamespaceContextAware(this.validationExpression, docElement, XPathReturnType.NODESET);
            if (nodeList.getLength() == 0) {
                throw new IllegalStateException(NOT_FOUND_ELEMENT_WITH_GIVEN_VALIDATION_EXPRESSION);
            }
            if (nodeList.getLength() > 1) {
                throw new IllegalStateException(MORE_THAN_ONE_ELEMENT_FOUND_WITH_GIVEN_VALIDATION_EXPRESSION);
            }
            Element element = (Element)nodeList.item(0);
            element.setIdAttribute("id", true);
        }
    }

    public static String getNotAbsoluteXpathExpressionErrorMessage(String validationExpression) {
        return String.format("The provided xpath expression '%s' is not absolute", validationExpression);
    }
}

