/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.registry.RegistrationException;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.xpath.SaxonXpathEvaluator;
import org.mule.module.xml.xpath.XPathReturnType;
import org.mule.security.utils.xmlsecurity.XMLSecureFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLUtils {
    private static final Logger logger = LoggerFactory.getLogger(XMLUtils.class);
    private static final String XPATH_ID_PATTERN = "//*[@id='%s']";

    public static byte[] createXmlUsing(Document doc) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            TransformerFactory transformerFactory = XMLSecureFactories.createDefault().getTransformerFactory();
            Transformer trans = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            trans.setOutputProperty("indent", "no");
            trans.transform(source, result);
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build signed org.mule.security.encryption.xml", e);
        }
    }

    public static Document documentBasedOnThe(byte[] xml) {
        try {
            DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(xml));
            document.normalize();
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create signed Document", e);
        }
    }

    public static byte[] toByteArray(Object obj, String encoding) {
        if (obj instanceof String) {
            if (encoding != null) {
                try {
                    return ((String)obj).getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("invalid encoding: " + encoding);
                }
            }
            return ((String)obj).getBytes();
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IllegalArgumentException("Unsupported message type: " + obj.getClass());
    }

    public static String toString(byte[] bytes, String encoding) {
        try {
            return encoding == null ? new String(bytes) : new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid encoding: " + encoding, e);
        }
    }

    public static String getIdXPathExpression(String id) {
        return String.format(XPATH_ID_PATTERN, id);
    }

    public static Object evaluateXpathExpression(String expression, Object source, QName returnType) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return xPath.evaluate(expression, source, returnType);
    }

    public static Object evaluateXpathExpressionWithNamespaceContextAware(String expression, Node source, XPathReturnType returnType) throws XPathExpressionException {
        MuleEvent muleEvent = RequestContext.getEvent();
        SaxonXpathEvaluator xPathEvaluator = new SaxonXpathEvaluator();
        NamespaceManager namespaceManager = null;
        try {
            namespaceManager = (NamespaceManager)muleEvent.getMuleContext().getRegistry().lookupObject(NamespaceManager.class);
            if (namespaceManager != null) {
                xPathEvaluator.registerNamespaces(namespaceManager);
            }
        }
        catch (RegistrationException e) {
            logger.debug("No namespace manager found. Will not register any namespaces");
        }
        return xPathEvaluator.evaluate(expression, source, returnType, muleEvent);
    }
}

