/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.utils.keyfactories;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;
import org.mule.util.IOUtils;

public class KeystoreEncryptionKeyFactory
implements EncryptionKeyFactory {
    public static final String PASSWORD_NOT_DEFINED_ERROR = "It is not possible to get the private key because the password key wasn't defined.";
    private KeyStore ks;
    private String password;
    private boolean symmetric;
    private String keyPassword;
    private String key;
    private boolean usePublicKeyToEncrypt;

    public KeystoreEncryptionKeyFactory(String keystore, String password, String keyPassword, String key, boolean symmetric) {
        this(keystore, password, keyPassword, key, symmetric, false);
    }

    public KeystoreEncryptionKeyFactory(String keystore, String password, String keyPassword, String key, boolean symmetric, boolean usePublicKeyToEncrypt) {
        try {
            this.key = key;
            this.password = password;
            this.symmetric = symmetric;
            this.keyPassword = keyPassword;
            this.usePublicKeyToEncrypt = usePublicKeyToEncrypt;
            this.validateKeystoreParameters();
            this.ks = KeyStore.getInstance(symmetric ? "JCEKS" : "JKS");
            this.ks.load(IOUtils.getResourceAsStream((String)keystore, this.getClass()), password.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read the Keystore", e);
        }
    }

    private void validateKeystoreParameters() {
        if (this.password == null) {
            throw new IllegalArgumentException("If keystore is defined then the keystore password must be defined");
        }
        if (this.key == null) {
            throw new IllegalArgumentException("If keystore is defined then the key must be defined");
        }
    }

    @Override
    public Key buildEncryptionKey() {
        if (this.symmetric || !this.usePublicKeyToEncrypt) {
            return this.buildKeyFromKeyStore();
        }
        return this.buildKeyFromCertificate();
    }

    @Override
    public Key buildDecryptionKey() {
        if (!this.symmetric && !this.usePublicKeyToEncrypt) {
            return this.buildKeyFromCertificate();
        }
        return this.buildKeyFromKeyStore();
    }

    public Key buildKeyFromCertificate() {
        try {
            Certificate cert = this.ks.getCertificate(this.key);
            if (cert != null) {
                return cert.getPublicKey();
            }
            throw new IllegalStateException(String.format("A key with alias %s wasn't found", this.key));
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("There was a problem trying to get the public key", e);
        }
    }

    public Key buildKeyFromKeyStore() {
        if (this.keyPassword == null) {
            throw new IllegalArgumentException(PASSWORD_NOT_DEFINED_ERROR);
        }
        try {
            return this.ks.getKey(this.key, this.keyPassword.toCharArray());
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getPlainKey() {
        return this.key;
    }
}

